/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesOakOpaque = "leaves_oak_opaque";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texLeavesJungleOpaque = "leaves_jungle_opaque";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texLogJungle = "log_jungle";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static ms iconGrassTop;
    public static ms iconGrassSide;
    public static ms iconGrassSideOverlay;
    public static ms iconSnow;
    public static ms iconGrassSideSnowed;
    public static ms iconMyceliumSide;
    public static ms iconMyceliumTop;
    public static ms iconWaterStill;
    public static ms iconWaterFlow;
    public static ms iconLavaStill;
    public static ms iconLavaFlow;
    public static ms iconPortal;
    public static ms iconFireLayer0;
    public static ms iconFireLayer1;
    private static IntBuffer staticBuffer;

    private static Set makeAtlasNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("/terrain.png");
        set.add("/gui/items.png");
        set.add("/ctm.png");
        set.add("/eloraam/world/world1.png");
        set.add("/gfx/buildcraft/blocks/blocks.png");
        return set;
    }

    public static void update() {
        bik mapBlocks = bik.textureMapBlocks;
        if (mapBlocks == null) {
            return;
        }
        iconGrassTop = mapBlocks.getIconSafe(texGrassTop);
        iconGrassSide = mapBlocks.getIconSafe(texGrassSide);
        iconGrassSideOverlay = mapBlocks.getIconSafe(texGrassSideOverlay);
        iconSnow = mapBlocks.getIconSafe(texSnow);
        iconGrassSideSnowed = mapBlocks.getIconSafe(texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getIconSafe(texMyceliumSide);
        iconMyceliumTop = mapBlocks.getIconSafe(texMyceliumTop);
        iconWaterStill = mapBlocks.getIconSafe(texWaterStill);
        iconWaterFlow = mapBlocks.getIconSafe(texWaterFlow);
        iconLavaStill = mapBlocks.getIconSafe(texLavaStill);
        iconLavaFlow = mapBlocks.getIconSafe(texLavaFlow);
        iconFireLayer0 = mapBlocks.getIconSafe(texFireLayer0);
        iconFireLayer1 = mapBlocks.getIconSafe(texFireLayer1);
        iconPortal = mapBlocks.getIconSafe(texPortal);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static bil getTextureAtlasSprite(ms icon) {
        if (icon instanceof bil) {
            return (bil)icon;
        }
        return null;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static void refreshBlockTextures() {
        Config.dbg("*** Reloading block textures ***");
        bik.textureMapBlocks.loadTextureSafe(Config.getResourceManager());
        TextureUtils.update();
        NaturalTextures.update();
        bik.textureMapBlocks.c();
    }

    public static bio getTexture(String path) {
        return TextureUtils.getTexture(new bjo(path));
    }

    public static bio getTexture(bjo loc) {
        bio tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new bif(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(bjp rm) {
        if (bik.textureMapBlocks == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        TextureAnimations.update();
        CustomColorizer.update();
        CustomSky.update();
        RandomMobs.resetTextures();
        Config.updateTexturePackClouds();
        Config.getTextureManager().d();
    }

    public static void refreshTextureMaps(bjp rm) {
        bik.textureMapBlocks.loadTextureSafe(rm);
        bik.textureMapItems.loadTextureSafe(rm);
        TextureUtils.update();
        NaturalTextures.update();
    }

    public static void registerResourceListener() {
        bjp rm = Config.getResourceManager();
        if (rm instanceof bjm) {
            bjm rrm = (bjm)rm;
            bjq rl = new bjq(){

                public void a(bjp var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl);
        }
        bir tto = new bir(){

            public void d() {
                TextureAnimations.updateCustomAnimations();
            }

            public void a(bjp var1) throws IOException {
            }

            public int b() {
                return 0;
            }
        };
        bjo ttol = new bjo("optifine/TickableTextures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strMcpatcher + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strMcpatcher + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void setupTexture(int width, int height, int gridSize, boolean useMipmaps) {
        boolean mipmapsActive;
        int minFilter = 9728;
        int magFilter = 9728;
        boolean bl = mipmapsActive = useMipmaps && Config.isUseMipmaps();
        if (mipmapsActive) {
            minFilter = Config.getMipmapType();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        int wrapMode = 33071;
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapMode);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapMode);
        if (mipmapsActive) {
            TextureUtils.updateMaxMipmapLevel(width, height, gridSize);
            Mipmaps.allocateMipmapTextures(width, height, "");
        }
        TextureUtils.updateAnisotropicLevel();
    }

    public static void updateMaxMipmapLevel(int width, int height, int gridSize) {
        if (Config.getMipmapLevel() <= 0) {
            return;
        }
        if (GLContext.getCapabilities().OpenGL12) {
            GL11.glTexParameteri((int)3553, (int)33084, (int)0);
            int mipmapLevel = Config.getMipmapLevel();
            if (mipmapLevel >= 4) {
                int minDim = Math.min(width, height);
                mipmapLevel = TextureUtils.getMaxMipmapLevel(minDim);
                if (gridSize > 1) {
                    int gridSizePo2;
                    mipmapLevel = gridSizePo2 = TextureUtils.getPowerOfTwo(gridSize);
                }
                if (mipmapLevel < 0) {
                    mipmapLevel = 0;
                }
            }
            GL11.glTexParameteri((int)3553, (int)33085, (int)mipmapLevel);
        }
    }

    public static void updateAnisotropicLevel() {
        if (GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    private static int getMaxMipmapLevel(int size) {
        int level = 0;
        while (size > 0) {
            size /= 2;
            ++level;
        }
        return level - 1;
    }

    public static IntBuffer getStaticBuffer(int w2, int h) {
        int len = w2 * h;
        if (staticBuffer == null || staticBuffer.capacity() < len) {
            len = TextureUtils.ceilPowerOfTwo(len);
            staticBuffer = atu.f((int)len);
        }
        return staticBuffer;
    }

    static {
        staticBuffer = atu.f((int)256);
    }
}

