/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldServerOF
extends mj {
    private NextTickHashSet pendingTickListEntriesHashSet;
    private TreeSet pendingTickListEntriesTreeSet;
    private List pendingTickListEntriesThisTick = new ArrayList();
    private int lastViewDistance = 0;
    private boolean allChunksTicked = false;
    public Set setChunkCoordsToTickOnce = new HashSet();
    private Set limitedChunkSet = new HashSet();
    private static final Logger logger = LogManager.getLogger();

    public WorldServerOF(MinecraftServer par1MinecraftServer, axo par2iSaveHandler, String par3Str, int par4, afv par5WorldSettings, ov par6Profiler) {
        super(par1MinecraftServer, par2iSaveHandler, par3Str, par4, par5WorldSettings, par6Profiler);
        this.fixSetNextTicks();
    }

    protected void a(afv par1WorldSettings) {
        super.a(par1WorldSettings);
        this.fixSetNextTicks();
    }

    private void fixSetNextTicks() {
        try {
            Field[] fields = mj.class.getDeclaredFields();
            int posSet = this.findField(fields, Set.class, 0);
            int posTreeSet = this.findField(fields, TreeSet.class, posSet);
            int posList = this.findField(fields, List.class, posTreeSet);
            if (posSet >= 0 && posTreeSet >= 0 && posList >= 0) {
                Field fieldSet = fields[posSet];
                Field fieldTreeSet = fields[posTreeSet];
                Field fieldList = fields[posList];
                fieldSet.setAccessible(true);
                fieldTreeSet.setAccessible(true);
                fieldList.setAccessible(true);
                this.pendingTickListEntriesTreeSet = (TreeSet)fieldTreeSet.get((Object)this);
                this.pendingTickListEntriesThisTick = (List)fieldList.get((Object)this);
                Set oldSet = (Set)fieldSet.get((Object)this);
                if (oldSet instanceof NextTickHashSet) {
                    return;
                }
                this.pendingTickListEntriesHashSet = new NextTickHashSet(oldSet);
                fieldSet.set((Object)this, this.pendingTickListEntriesHashSet);
                Config.dbg("WorldServer.nextTickSet updated");
                return;
            }
            Config.warn("Error updating WorldServer.nextTickSet");
        }
        catch (Exception e) {
            Config.warn("Error setting WorldServer.nextTickSet: " + e.getMessage());
        }
    }

    private int findField(Field[] fields, Class cls, int startPos) {
        if (startPos < 0) {
            return -1;
        }
        for (int i = startPos; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getType() != cls) continue;
            return i;
        }
        return -1;
    }

    public List a(aoj par1Chunk, boolean par2) {
        if (this.pendingTickListEntriesHashSet == null || this.pendingTickListEntriesTreeSet == null || this.pendingTickListEntriesThisTick == null) {
            return super.a(par1Chunk, par2);
        }
        ArrayList<age> var3 = null;
        afg var4 = par1Chunk.l();
        int var5 = (var4.a << 4) - 2;
        int var6 = var5 + 16 + 2;
        int var7 = (var4.b << 4) - 2;
        int var8 = var7 + 16 + 2;
        for (int var9 = 0; var9 < 2; ++var9) {
            Iterator var10;
            if (var9 == 0) {
                TreeSet setAll = new TreeSet();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        HashSet set = this.pendingTickListEntriesHashSet.getNextTickEntriesSet(var4.a + dx, var4.b + dz);
                        setAll.addAll(set);
                    }
                }
                var10 = setAll.iterator();
            } else {
                var10 = this.pendingTickListEntriesThisTick.iterator();
                if (!this.pendingTickListEntriesThisTick.isEmpty()) {
                    logger.debug("toBeTicked = " + this.pendingTickListEntriesThisTick.size());
                }
            }
            while (var10.hasNext()) {
                age var11 = (age)var10.next();
                if (var11.a < var5 || var11.a >= var6 || var11.c < var7 || var11.c >= var8) continue;
                if (par2) {
                    this.pendingTickListEntriesHashSet.remove(var11);
                    this.pendingTickListEntriesTreeSet.remove(var11);
                    var10.remove();
                }
                if (var3 == null) {
                    var3 = new ArrayList<age>();
                }
                var3.add(var11);
            }
        }
        return var3;
    }

    public void b() {
        super.b();
        if (!Config.isTimeDefault()) {
            this.fixWorldTime();
        }
        if (Config.waterOpacityChanged) {
            Config.waterOpacityChanged = false;
            this.updateWaterOpacity();
        }
    }

    protected void o() {
        if (!Config.isWeatherEnabled()) {
            this.fixWorldWeather();
        }
        super.o();
    }

    private void fixWorldWeather() {
        if (this.x.p() || this.x.n()) {
            this.x.g(0);
            this.x.b(false);
            this.k(0.0f);
            this.x.f(0);
            this.x.a(false);
            this.i(0.0f);
            this.p().af().a((fk)new gm(2, 0.0f));
            this.p().af().a((fk)new gm(7, 0.0f));
            this.p().af().a((fk)new gm(8, 0.0f));
        }
    }

    private void fixWorldTime() {
        if (this.x.r().a() != 1) {
            return;
        }
        long time = this.I();
        long timeOfDay = time % 24000L;
        if (Config.isTimeDayOnly()) {
            if (timeOfDay <= 1000L) {
                this.b(time - timeOfDay + 1001L);
            }
            if (timeOfDay >= 11000L) {
                this.b(time - timeOfDay + 24001L);
            }
        }
        if (Config.isTimeNightOnly()) {
            if (timeOfDay <= 14000L) {
                this.b(time - timeOfDay + 14001L);
            }
            if (timeOfDay >= 22000L) {
                this.b(time - timeOfDay + 24000L + 14001L);
            }
        }
    }

    public void updateWaterOpacity() {
        int opacity = 3;
        if (Config.isClearWater()) {
            opacity = 1;
        }
        BlockUtils.setLightOpacity(ahz.j, opacity);
        BlockUtils.setLightOpacity((ahu)ahz.i, opacity);
        aog cp = this.v;
        if (cp == null) {
            return;
        }
        for (int x = -512; x < 512; ++x) {
            for (int z = -512; z < 512; ++z) {
                aoj c;
                if (!cp.a(x, z) || (c = cp.d(x, z)) == null || c instanceof aoi) continue;
                aol[] ebss = c.i();
                for (int i = 0; i < ebss.length; ++i) {
                    aoh na;
                    aol ebs = ebss[i];
                    if (ebs == null || (na = ebs.l()) == null) continue;
                    byte[] data = na.a;
                    for (int d = 0; d < data.length; ++d) {
                        data[d] = 0;
                    }
                }
                c.b();
            }
        }
    }

    public void g(qn par1Entity) {
        if (this.canSkipEntityUpdate(par1Entity) && par1Entity instanceof rh) {
            float brightness;
            rh elb = (rh)par1Entity;
            int entityAge = EntityUtils.getEntityAge(elb);
            ++entityAge;
            if (elb instanceof ws && (brightness = elb.d(1.0f)) > 0.5f) {
                entityAge += 2;
            }
            EntityUtils.setEntityAge(elb, entityAge);
            if (elb instanceof ri) {
                ri el = (ri)elb;
                EntityUtils.despawnEntity(el);
            }
            return;
        }
        super.g(par1Entity);
        if (Config.isSmoothWorld()) {
            Thread.currentThread();
            Thread.yield();
        }
    }

    private boolean canSkipEntityUpdate(qn entity) {
        double dz;
        if (!(entity instanceof rh)) {
            return false;
        }
        rh entityLiving = (rh)entity;
        if (entityLiving.f()) {
            return false;
        }
        if (entityLiving.ay > 0) {
            return false;
        }
        if (entity.ab < 20) {
            return false;
        }
        if (this.h.size() != 1) {
            return false;
        }
        qn player = (qn)this.h.get(0);
        double dx = Math.abs(entity.t - player.t) - 16.0;
        double distSq = dx * dx + (dz = Math.abs(entity.v - player.v) - 16.0) * dz;
        return !entity.a(distSq);
    }

    protected void B() {
        super.B();
        this.limitedChunkSet.clear();
        int viewDistance = this.p().af().o();
        if (viewDistance <= 10) {
            return;
        }
        if (viewDistance != this.lastViewDistance) {
            this.lastViewDistance = viewDistance;
            this.allChunksTicked = false;
            return;
        }
        if (!this.allChunksTicked) {
            this.allChunksTicked = true;
            return;
        }
        for (int i = 0; i < this.h.size(); ++i) {
            xl player = (xl)this.h.get(i);
            int pcx = ou.c(player.t / 16.0);
            int pcz = ou.c(player.v / 16.0);
            int dist = 10;
            for (int cx = -dist; cx <= dist; ++cx) {
                for (int cz = -dist; cz <= dist; ++cz) {
                    this.limitedChunkSet.add(new afg(cx + pcx, cz + pcz));
                }
            }
        }
        if (this.setChunkCoordsToTickOnce.size() > 0) {
            this.limitedChunkSet.addAll(this.setChunkCoordsToTickOnce);
            this.setChunkCoordsToTickOnce.clear();
        }
    }

    public void addChunkToTickOnce(int cx, int cz) {
        int viewDistance = this.p().af().o();
        if (viewDistance <= 10) {
            return;
        }
        this.setChunkCoordsToTickOnce.add(new afg(cx, cz));
    }

    protected void g() {
        Set oldSet = this.F;
        if (this.limitedChunkSet.size() > 0) {
            this.F = this.limitedChunkSet;
        }
        super.g();
        this.F = oldSet;
    }
}

