/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class RandomMobs {
    private static Map textureVariantsMap = new HashMap();
    private static ckn renderGlobal = null;
    private static boolean initialized = false;
    private static Random random = new Random();
    private static Field fieldEntityUuid = RandomMobs.getField(wv.class, UUID.class);
    private static boolean working = false;

    public static void entityLoaded(wv entity) {
        if (!(entity instanceof xn)) {
            return;
        }
        xn el = (xn)entity;
        qt ws = Config.getWorldServer();
        if (ws == null) {
            return;
        }
        wv es = ws.a(entity.F());
        if (!(es instanceof xn)) {
            return;
        }
        xn els = (xn)es;
        if (fieldEntityUuid != null) {
            try {
                Object uuid = fieldEntityUuid.get(els);
                fieldEntityUuid.set(el, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
                fieldEntityUuid = null;
            }
        }
    }

    private static Field getField(Class cls2, Class fieldType) {
        try {
            Field[] fields = cls2.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Class<?> type = field.getType();
                if (type != fieldType) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void worldChanged(aqu oldWorld, aqu newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.E();
            for (int e = 0; e < entityList.size(); ++e) {
                wv entity = (wv)entityList.get(e);
                RandomMobs.entityLoaded(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static oa getTextureLocation(oa loc) {
        if (working) {
            return loc;
        }
        try {
            working = true;
            if (!initialized) {
                RandomMobs.initialize();
            }
            if (renderGlobal == null) {
                oa oa2 = loc;
                return oa2;
            }
            wv entity = RandomMobs.renderGlobal.renderedEntity;
            if (entity == null) {
                oa oa3 = loc;
                return oa3;
            }
            if (!(entity instanceof xn)) {
                oa oa4 = loc;
                return oa4;
            }
            String name = loc.a();
            if (!name.startsWith("textures/entity/")) {
                oa oa5 = loc;
                return oa5;
            }
            long uuidLow = entity.aJ().getLeastSignificantBits();
            int id2 = (int)(uuidLow & Integer.MAX_VALUE);
            oa oa6 = RandomMobs.getTextureLocation(loc, id2);
            return oa6;
        }
        finally {
            working = false;
        }
    }

    private static oa getTextureLocation(oa loc, int randomId) {
        if (randomId <= 0) {
            return loc;
        }
        String name = loc.a();
        oa[] texLocs = (oa[])textureVariantsMap.get(name);
        if (texLocs == null) {
            texLocs = RandomMobs.getTextureVariants(loc);
            textureVariantsMap.put(name, texLocs);
        }
        if (texLocs == null || texLocs.length <= 0) {
            return loc;
        }
        int index = randomId % texLocs.length;
        oa texLoc = texLocs[index];
        return texLoc;
    }

    private static oa[] getTextureVariants(oa loc) {
        TextureUtils.getTexture(loc);
        oa[] texLocs = new oa[]{};
        String name = loc.a();
        int pointPos = name.lastIndexOf(46);
        if (pointPos < 0) {
            return texLocs;
        }
        String prefix = name.substring(0, pointPos);
        String suffix = name.substring(pointPos);
        String texEntStr = "textures/entity/";
        if (!prefix.startsWith(texEntStr)) {
            return texLocs;
        }
        prefix = prefix.substring(texEntStr.length());
        prefix = "mcpatcher/mob/" + prefix;
        int countVariants = RandomMobs.getCountTextureVariants(prefix, suffix);
        if (countVariants <= 1) {
            return texLocs;
        }
        texLocs = new oa[countVariants];
        texLocs[0] = loc;
        for (int i = 1; i < texLocs.length; ++i) {
            int texNum = i + 1;
            String texName = prefix + texNum + suffix;
            texLocs[i] = new oa(loc.b(), texName);
            TextureUtils.getTexture(texLocs[i]);
        }
        Config.dbg("RandomMobs: " + loc + ", variants: " + texLocs.length);
        return texLocs;
    }

    private static int getCountTextureVariants(String prefix, String suffix) {
        int maxNum = 1000;
        for (int num = 2; num < maxNum; ++num) {
            String variant = prefix + num + suffix;
            oa loc = new oa(variant);
            if (Config.hasResource(loc)) continue;
            return num - 1;
        }
        return maxNum;
    }

    public static void resetTextures() {
        textureVariantsMap.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        if (renderGlobal == null) {
            return;
        }
        initialized = true;
        ArrayList<String> list = new ArrayList<String>();
        list.add("bat");
        list.add("blaze");
        list.add("cat/black");
        list.add("cat/ocelot");
        list.add("cat/red");
        list.add("cat/siamese");
        list.add("chicken");
        list.add("cow/cow");
        list.add("cow/mooshroom");
        list.add("creeper/creeper");
        list.add("enderman/enderman");
        list.add("enderman/enderman_eyes");
        list.add("ghast/ghast");
        list.add("ghast/ghast_shooting");
        list.add("iron_golem");
        list.add("pig/pig");
        list.add("sheep/sheep");
        list.add("sheep/sheep_fur");
        list.add("silverfish");
        list.add("skeleton/skeleton");
        list.add("skeleton/wither_skeleton");
        list.add("slime/slime");
        list.add("slime/magmacube");
        list.add("snowman");
        list.add("spider/cave_spider");
        list.add("spider/spider");
        list.add("spider_eyes");
        list.add("squid");
        list.add("villager/villager");
        list.add("villager/butcher");
        list.add("villager/farmer");
        list.add("villager/librarian");
        list.add("villager/priest");
        list.add("villager/smith");
        list.add("wither/wither");
        list.add("wither/wither_armor");
        list.add("wither/wither_invulnerable");
        list.add("wolf/wolf");
        list.add("wolf/wolf_angry");
        list.add("wolf/wolf_collar");
        list.add("wolf/wolf_tame");
        list.add("zombie_pigman");
        list.add("zombie/zombie");
        list.add("zombie/zombie_villager");
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            String tex = "textures/entity/" + name + ".png";
            oa texLoc = new oa(tex);
            if (!Config.hasResource(texLoc)) {
                Config.warn("Not found: " + texLoc);
            }
            RandomMobs.getTextureLocation(texLoc, 100);
        }
    }
}

