/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import shadersmod.client.Shaders;
import shadersmod.client.ShadersRender;

public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static bph itemModelGenerator = new bph();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "items/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "items/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "items/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final Map<String, Integer> mapPotionDamages = CustomItems.makeMapPotionDamages();
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void updateIcons(bwd textureMap) {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (!Config.isCustomItems()) {
            return;
        }
        CustomItems.readCitProperties("mcpatcher/cit.properties");
        bxf[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            bxf rp2 = rps[i];
            CustomItems.updateIcons(textureMap, rp2);
        }
        CustomItems.updateIcons(textureMap, (bxf)Config.getDefaultResourcePack());
        if (itemProperties.length <= 0) {
            itemProperties = null;
        }
        if (enchantmentProperties.length <= 0) {
            enchantmentProperties = null;
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            kn loc = new kn(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            Config.dbg("CustomItems: Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            in.close();
            useGlint = Config.parseBoolean(props.getProperty("useGlint"), true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void updateIcons(bwd textureMap, bxf rp2) {
        CustomItemProperties[] cips;
        int i;
        Object[] names = ResUtils.collectFiles(rp2, "mcpatcher/cit/", ".properties", null);
        Map mapAutoProperties = CustomItems.makeAutoImageProperties(rp2);
        if (mapAutoProperties.size() > 0) {
            Set keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray(names, keysAuto);
        }
        Arrays.sort(names);
        List itemList = CustomItems.makePropertyList(itemProperties);
        List enchantmentList = CustomItems.makePropertyList(enchantmentProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("CustomItems: " + (String)name);
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = (CustomItemProperties)mapAutoProperties.get(name);
                }
                if (cip == null) {
                    kn locFile = new kn((String)name);
                    InputStream in = rp2.a(locFile);
                    if (in == null) {
                        Config.warn("CustomItems file not found: " + (String)name);
                        continue;
                    }
                    Properties props = new Properties();
                    props.load(in);
                    cip = new CustomItemProperties(props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                cip.updateIcons(textureMap);
                CustomItems.addToItemList(cip, itemList);
                CustomItems.addToEnchantmentList(cip, enchantmentList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("CustomItems file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray(itemList);
        enchantmentProperties = CustomItems.propertyListToArray(enchantmentList);
        Comparator comp = CustomItems.getPropertiesComparator();
        for (i = 0; i < itemProperties.length; ++i) {
            cips = itemProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
        for (i = 0; i < enchantmentProperties.length; ++i) {
            cips = enchantmentProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
    }

    private static Comparator getPropertiesComparator() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                CustomItemProperties cip1 = (CustomItemProperties)o1;
                CustomItemProperties cip2 = (CustomItemProperties)o2;
                if (cip1.layer != cip2.layer) {
                    return cip1.layer - cip2.layer;
                }
                if (cip1.weight != cip2.weight) {
                    return cip2.weight - cip1.weight;
                }
                if (!cip1.basePath.equals(cip2.basePath)) {
                    return cip1.basePath.compareTo(cip2.basePath);
                }
                return cip1.name.compareTo(cip2.name);
            }
        };
        return comp;
    }

    public static void updateModels() {
        if (itemProperties == null) {
            return;
        }
        for (int id = 0; id < itemProperties.length; ++id) {
            CustomItemProperties[] cips = itemProperties[id];
            if (cips == null) continue;
            for (int c2 = 0; c2 < cips.length; ++c2) {
                CustomItemProperties cip = cips[c2];
                if (cip == null || cip.type != 1) continue;
                bwd textureMap = bcx.z().R();
                cip.updateModel(textureMap, itemModelGenerator);
            }
        }
    }

    private static Map makeAutoImageProperties(bxf rp2) {
        HashMap map = new HashMap();
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_NORMAL, adx.a((adx)aeb.bG)));
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_SPLASH, adx.a((adx)aeb.bH)));
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_LINGER, adx.a((adx)aeb.bI)));
        return map;
    }

    private static Map makePotionImageProperties(bxf rp2, String type, int itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String typePrefix = type + "/";
        String[] prefixes = new String[]{"mcpatcher/cit/potion/" + typePrefix, "mcpatcher/cit/Potion/" + typePrefix};
        String[] suffixes = new String[]{".png"};
        String[] names = ResUtils.collectFiles(rp2, prefixes, suffixes);
        for (int i = 0; i < names.length; ++i) {
            String path;
            String name = path = names[i];
            Properties props = CustomItems.makePotionProperties(name = StrUtils.removePrefixSuffix(name, prefixes, suffixes), type, itemId, path);
            if (props == null) continue;
            String pathProp = StrUtils.removeSuffix(path, suffixes) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, int itemId, String path) {
        if (StrUtils.endsWith(name, new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals(TYPE_POTION_NORMAL)) {
            itemId = adx.a((adx)aeb.bJ);
            Properties props = new Properties();
            props.put("type", "item");
            props.put("items", "" + itemId);
            return props;
        }
        int potionItemId = itemId;
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i = 0; i < damages.length; ++i) {
            int damage = damages[i];
            if (type.equals(TYPE_POTION_SPLASH)) {
                damage |= 0x4000;
            }
            if (i > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            damageMask |= 0x40;
        }
        Properties props = new Properties();
        props.put("type", "item");
        props.put("items", "" + potionItemId);
        props.put("damage", "" + bufDamage.toString());
        props.put("damageMask", "" + damageMask);
        if (type.equals(TYPE_POTION_SPLASH)) {
            props.put(KEY_TEXTURE_SPLASH, name);
        } else {
            props.put(KEY_TEXTURE_DRINKABLE, name);
        }
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId(0, 0));
            mapPotionIds.put("awkward", CustomItems.getPotionId(0, 1));
            mapPotionIds.put("thick", CustomItems.getPotionId(0, 2));
            mapPotionIds.put("potent", CustomItems.getPotionId(0, 3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionId(7, 0));
            mapPotionIds.put("bungling", CustomItems.getPotionId(7, 1));
            mapPotionIds.put("charming", CustomItems.getPotionId(7, 2));
            mapPotionIds.put("rank", CustomItems.getPotionId(7, 3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds(11));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionId(15, 0));
            mapPotionIds.put("debonair", CustomItems.getPotionId(15, 1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId(15, 2));
            mapPotionIds.put("stinky", CustomItems.getPotionId(15, 3));
            mapPotionIds.put("mundane", CustomItems.getPotionId(0, 4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "effect." + name;
        Set keys = rp.b.c();
        for (kn rl : keys) {
            rp potion = (rp)rp.b.c((Object)rl);
            String potionName = potion.a();
            if (!fullName.equals(potionName)) continue;
            return rp.a((rp)potion);
        }
        return -1;
    }

    private static List makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<ArrayList<CustomItemProperties>> list = new ArrayList<ArrayList<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                CustomItemProperties[] props = propsArr[i];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i = 0; i < cp.items.length; ++i) {
            int itemId = cp.items[i];
            if (itemId <= 0) {
                Config.warn("Invalid item ID: " + itemId);
                continue;
            }
            CustomItems.addToList(cp, itemList, itemId);
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List enchantmentList) {
        if (cp.type != 2) {
            return;
        }
        if (cp.enchantmentIds == null) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            int id = i;
            if (!cp.enchantmentIds.isInRange(id)) continue;
            CustomItems.addToList(cp, enchantmentList, id);
        }
    }

    private static void addToList(CustomItemProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomItemProperties> subList = (ArrayList<CustomItemProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static byl getCustomItemModel(adz itemStack, byl model, kn modelLocation) {
        if (model.b()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 1);
        if (props == null) {
            return model;
        }
        return props.getModel(modelLocation);
    }

    public static boolean bindCustomArmorTexture(adz itemStack, sb slot, String overlay) {
        if (itemProperties == null) {
            return false;
        }
        kn loc = CustomItems.getCustomArmorLocation(itemStack, slot, overlay);
        if (loc == null) {
            return false;
        }
        Config.getTextureManager().a(loc);
        return true;
    }

    private static kn getCustomArmorLocation(adz itemStack, sb slot, String overlay) {
        String key;
        kn loc;
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 3);
        if (props == null) {
            return null;
        }
        if (props.mapTextureLocations == null) {
            return props.textureLocation;
        }
        adx item = itemStack.b();
        if (!(item instanceof acf)) {
            return null;
        }
        acf itemArmor = (acf)item;
        String material = itemArmor.d().d();
        int layer = slot == sb.d ? 2 : 1;
        StringBuffer sb2 = new StringBuffer();
        sb2.append("texture.");
        sb2.append(material);
        sb2.append("_layer_");
        sb2.append(layer);
        if (overlay != null) {
            sb2.append("_");
            sb2.append(overlay);
        }
        if ((loc = (kn)props.mapTextureLocations.get(key = sb2.toString())) == null) {
            return props.textureLocation;
        }
        return loc;
    }

    public static kn getCustomElytraTexture(adz itemStack, kn locElytra) {
        if (itemProperties == null) {
            return locElytra;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 4);
        if (props == null) {
            return locElytra;
        }
        if (props.textureLocation == null) {
            return locElytra;
        }
        return props.textureLocation;
    }

    private static CustomItemProperties getCustomItemProperties(adz itemStack, int type) {
        CustomItemProperties[] cips;
        if (itemProperties == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        adx item = itemStack.b();
        int itemId = adx.a((adx)item);
        if (itemId >= 0 && itemId < itemProperties.length && (cips = itemProperties[itemId]) != null) {
            for (int i = 0; i < cips.length; ++i) {
                CustomItemProperties cip = cips[i];
                if (cip.type != type || !CustomItems.matchesProperties(cip, itemStack, null)) continue;
                return cip;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, adz itemStack, int[][] enchantmentIdLevels) {
        int i;
        adx item = itemStack.b();
        if (cip.damage != null) {
            int damage = CustomItems.getItemStackDamage(itemStack);
            if (damage < 0) {
                return false;
            }
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int damageMax = item.l();
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.b)) {
            return false;
        }
        int[][] idLevels = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean idMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int id = idLevels[i][0];
                if (!cip.enchantmentIds.isInRange(id)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean levelMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int level = idLevels[i][1];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            dr nbt = itemStack.o();
            for (i = 0; i < cip.nbtTagValues.length; ++i) {
                NbtTagValue ntv = cip.nbtTagValues[i];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int getItemStackDamage(adz itemStack) {
        adx item = itemStack.b();
        if (item instanceof aem) {
            return CustomItems.getPotionDamage(itemStack);
        }
        return itemStack.h();
    }

    private static int getPotionDamage(adz itemStack) {
        dr nbt = itemStack.o();
        if (nbt == null) {
            return 0;
        }
        String name = nbt.l("Potion");
        if (name == null) {
            return 0;
        }
        Integer value = mapPotionDamages.get(name);
        if (value == null) {
            return -1;
        }
        int val = value;
        if (itemStack.b() == aeb.bH) {
            val |= 0x4000;
        }
        return val;
    }

    private static Map<String, Integer> makeMapPotionDamages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomItems.addPotion("water", 0, false, map);
        CustomItems.addPotion("awkward", 16, false, map);
        CustomItems.addPotion("thick", 32, false, map);
        CustomItems.addPotion("mundane", 64, false, map);
        CustomItems.addPotion("regeneration", 1, true, map);
        CustomItems.addPotion("swiftness", 2, true, map);
        CustomItems.addPotion("fire_resistance", 3, true, map);
        CustomItems.addPotion("poison", 4, true, map);
        CustomItems.addPotion("healing", 5, true, map);
        CustomItems.addPotion("night_vision", 6, true, map);
        CustomItems.addPotion("weakness", 8, true, map);
        CustomItems.addPotion("strength", 9, true, map);
        CustomItems.addPotion("slowness", 10, true, map);
        CustomItems.addPotion("leaping", 11, true, map);
        CustomItems.addPotion("harming", 12, true, map);
        CustomItems.addPotion("water_breathing", 13, true, map);
        CustomItems.addPotion("invisibility", 14, true, map);
        return map;
    }

    private static void addPotion(String name, int value, boolean extended, Map<String, Integer> map) {
        if (extended) {
            value |= 0x2000;
        }
        map.put("minecraft:" + name, value);
        if (extended) {
            int valueStrong = value | 0x20;
            map.put("minecraft:strong_" + name, valueStrong);
            int valueLong = value | 0x40;
            map.put("minecraft:long_" + name, valueLong);
        }
    }

    private static int[][] getEnchantmentIdLevels(adz itemStack) {
        dx nbt;
        adx item = itemStack.b();
        dx dx2 = nbt = item == aeb.cn ? aeb.cn.h(itemStack) : itemStack.p();
        if (nbt == null || nbt.c() <= 0) {
            return EMPTY_INT2_ARRAY;
        }
        int[][] arr = new int[nbt.c()][2];
        for (int i = 0; i < nbt.c(); ++i) {
            dr tag = nbt.b(i);
            short id = tag.g("id");
            short lvl = tag.g("lvl");
            arr[i][0] = id;
            arr[i][1] = lvl;
        }
        return arr;
    }

    public static boolean renderCustomEffect(bsu renderItem, adz itemStack, byl model) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        HashSet<Integer> layersRendered = null;
        boolean rendered = false;
        bwf textureManager = Config.getTextureManager();
        for (int i = 0; i < idLevels.length; ++i) {
            CustomItemProperties[] cips;
            int id = idLevels[i][0];
            if (id < 0 || id >= enchantmentProperties.length || (cips = enchantmentProperties[id]) == null) continue;
            for (int p = 0; p < cips.length; ++p) {
                CustomItemProperties cip = cips[p];
                if (layersRendered == null) {
                    layersRendered = new HashSet<Integer>();
                }
                if (!layersRendered.add(id) || !CustomItems.matchesProperties(cip, itemStack, idLevels) || cip.textureLocation == null) continue;
                textureManager.a(cip.textureLocation);
                float width = cip.getTextureWidth(textureManager);
                if (!rendered) {
                    rendered = true;
                    bob.a((boolean)false);
                    bob.c((int)514);
                    bob.g();
                    bob.n((int)5890);
                }
                Blender.setupBlend(cip.blend, 1.0f);
                bob.G();
                bob.b((float)(width / 2.0f), (float)(width / 2.0f), (float)(width / 2.0f));
                float offset = cip.speed * (float)(bcx.I() % 3000L) / 3000.0f / 8.0f;
                bob.c((float)offset, (float)0.0f, (float)0.0f);
                bob.b((float)cip.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                renderItem.a(model, -1);
                bob.H();
            }
        }
        if (rendered) {
            bob.e();
            bob.m();
            bob.b((int)770, (int)771);
            bob.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bob.n((int)5888);
            bob.f();
            bob.c((int)515);
            bob.a((boolean)true);
            textureManager.a(bwd.g);
        }
        return rendered;
    }

    public static boolean renderCustomArmorEffect(sf entity, adz itemStack, bju model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        HashSet<Integer> layersRendered = null;
        boolean rendered = false;
        bwf textureManager = Config.getTextureManager();
        for (int i = 0; i < idLevels.length; ++i) {
            CustomItemProperties[] cips;
            int id = idLevels[i][0];
            if (id < 0 || id >= enchantmentProperties.length || (cips = enchantmentProperties[id]) == null) continue;
            for (int p = 0; p < cips.length; ++p) {
                CustomItemProperties cip = cips[p];
                if (layersRendered == null) {
                    layersRendered = new HashSet<Integer>();
                }
                if (!layersRendered.add(id) || !CustomItems.matchesProperties(cip, itemStack, idLevels) || cip.textureLocation == null) continue;
                textureManager.a(cip.textureLocation);
                float width = cip.getTextureWidth(textureManager);
                if (!rendered) {
                    rendered = true;
                    if (Config.isShaders()) {
                        ShadersRender.renderEnchantedGlintBegin();
                    }
                    bob.m();
                    bob.c((int)514);
                    bob.a((boolean)false);
                }
                Blender.setupBlend(cip.blend, 1.0f);
                bob.g();
                bob.n((int)5890);
                bob.F();
                bob.b((float)cip.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                float texScale = width / 8.0f;
                bob.b((float)texScale, (float)(texScale / 2.0f), (float)texScale);
                float offset = cip.speed * (float)(bcx.I() % 3000L) / 3000.0f / 8.0f;
                bob.c((float)0.0f, (float)offset, (float)0.0f);
                bob.n((int)5888);
                model.a((rw)entity, limbSwing, prevLimbSwing, timeLimbSwing, yaw, pitch, scale);
            }
        }
        if (rendered) {
            bob.e();
            bob.m();
            bob.b((int)770, (int)771);
            bob.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bob.n((int)5890);
            bob.F();
            bob.n((int)5888);
            bob.f();
            bob.a((boolean)true);
            bob.c((int)515);
            bob.l();
            if (Config.isShaders()) {
                ShadersRender.renderEnchantedGlintEnd();
            }
        }
        return rendered;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }

    public static void setRenderOffHand(boolean renderOffHand) {
        CustomItems.renderOffHand = renderOffHand;
    }
}

