/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.EnumModelVariable;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariable;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private blv model;
    private CustomModelRenderer[] customModelRenderers;
    private bni thisModelRenderer;
    private bni partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, blv model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Class entityClass = modelAdapter.getEntityClass();
        this.renderResolver = asc.class.isAssignableFrom(entityClass) ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariable mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression expr = this.renderResolver.getParameter(name);
        if (expr != null) {
            return expr;
        }
        return null;
    }

    @Override
    public bni getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize(name, ":");
            bni mr = this.getModelRenderer(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                bni mrSub = mr.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr = mrSub;
            }
            return mr;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        bni mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i = 0; i < this.customModelRenderers.length; ++i) {
            CustomModelRenderer cmr = this.customModelRenderers[i];
            bni mr = cmr.getModelRenderer();
            if (name.equals(mr.getId())) {
                return mr;
            }
            bni mrChild = mr.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    @Override
    public ModelVariable getModelVariable(String name) {
        String[] parts = Config.tokenize(name, ".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        bni mr = this.getModelRenderer(modelName);
        if (mr == null) {
            return null;
        }
        EnumModelVariable varType = EnumModelVariable.parse(varName);
        if (varType == null) {
            return null;
        }
        return new ModelVariable(name, mr, varType);
    }

    public void setPartModelRenderer(bni partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(bni thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

