/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class TooltipManager {
    private blk guiScreen = null;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public TooltipManager(blk guiScreen) {
        this.guiScreen = guiScreen;
    }

    public void drawTooltips(int x, int y, List buttonList) {
        if (Math.abs(x - this.lastMouseX) > 5 || Math.abs(y - this.lastMouseY) > 5) {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
            return;
        }
        int activateDelay = 700;
        if (System.currentTimeMillis() < this.mouseStillTime + (long)activateDelay) {
            return;
        }
        int x1 = this.guiScreen.l / 2 - 150;
        int y1 = this.guiScreen.m / 6 - 7;
        if (y <= y1 + 98) {
            y1 += 105;
        }
        int x2 = x1 + 150 + 150;
        int y2 = y1 + 84 + 10;
        bja btn = this.getSelectedButton(x, y, buttonList);
        if (btn instanceof IOptionControl) {
            IOptionControl ctl = (IOptionControl)btn;
            bid.a option = ctl.getOption();
            String[] lines = TooltipManager.getTooltipLines(option);
            if (lines == null) {
                return;
            }
            bls.a((int)x1, (int)y1, (int)x2, (int)y2, (int)-536870912);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int col = 0xDDDDDD;
                if (line.endsWith("!")) {
                    col = 0xFF2020;
                }
                bip fontRenderer = bib.z().k;
                fontRenderer.a(line, (float)(x1 + 5), (float)(y1 + 5 + i * 11), col);
            }
        }
    }

    private bja getSelectedButton(int x, int y, List buttonList) {
        for (int k = 0; k < buttonList.size(); ++k) {
            boolean flag;
            bja btn = (bja)buttonList.get(k);
            int btnWidth = bls.getButtonWidth((bja)btn);
            int btnHeight = bls.getButtonHeight((bja)btn);
            boolean bl = flag = x >= btn.h && y >= btn.i && x < btn.h + btnWidth && y < btn.i + btnHeight;
            if (!flag) continue;
            return btn;
        }
        return null;
    }

    private static String[] getTooltipLines(bid.a option) {
        return TooltipManager.getTooltipLines(option.d());
    }

    private static String[] getTooltipLines(String key) {
        String lineKey;
        String line;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 10 && (line = Lang.get(lineKey = key + ".tooltip." + (i + 1), null)) != null; ++i) {
            list.add(line);
        }
        if (list.size() <= 0) {
            return null;
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }
}

