/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static cft mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static pc getTextureLocation(pc loc) {
        aer entity;
        if (guiProperties == null) {
            return loc;
        }
        ckd screen = CustomGuis.mc.m;
        if (!(screen instanceof cky)) {
            return loc;
        }
        if (!loc.b().equals("minecraft") || !loc.a().startsWith("textures/gui/")) {
            return loc;
        }
        if (playerControllerOF == null) {
            return loc;
        }
        crg world = CustomGuis.mc.g;
        if (world == null) {
            return loc;
        }
        if (screen instanceof clh) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.i.bH(), (aye)world, loc, screen);
        }
        if (screen instanceof clp) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.i.bH(), (aye)world, loc, screen);
        }
        el pos = playerControllerOF.getLastClickBlockPos();
        if (pos != null) {
            if (screen instanceof ckz) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cla) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, pos, (aye)world, loc, screen);
            }
            if (screen instanceof clc) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cle) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, pos, (aye)world, loc, screen);
            }
            if (screen instanceof clf) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cli) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cll) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, pos, (aye)world, loc, screen);
            }
            if (screen instanceof clm) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cln) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, pos, (aye)world, loc, screen);
            }
            if (screen instanceof cls) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, pos, (aye)world, loc, screen);
            }
        }
        if ((entity = playerControllerOF.getLastClickEntity()) != null) {
            if (screen instanceof clo) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, (aye)world, loc);
            }
            if (screen instanceof clq) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, (aye)world, loc);
            }
        }
        return loc;
    }

    private static pc getTexturePos(CustomGuiProperties.EnumContainer container, el pos, aye blockAccess, pc loc, ckd screen) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i2 = 0; i2 < props.length; ++i2) {
            CustomGuiProperties prop = props[i2];
            if (!prop.matchesPos(container, pos, blockAccess, screen)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    private static pc getTextureEntity(CustomGuiProperties.EnumContainer container, aer entity, aye blockAccess, pc loc) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i2 = 0; i2 < props.length; ++i2) {
            CustomGuiProperties prop = props[i2];
            if (!prop.matchesEntity(container, entity, blockAccess)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (!Config.isCustomGuis()) {
            return;
        }
        ArrayList<List<CustomGuiProperties>> listProps = new ArrayList<List<CustomGuiProperties>>();
        ul[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            ul rp = rps[i2];
            CustomGuis.update(rp, listProps);
        }
        guiProperties = CustomGuis.propertyListToArray(listProps);
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] cgps = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        for (int i2 = 0; i2 < cgps.length; ++i2) {
            List<CustomGuiProperties> subList;
            if (listProps.size() <= i2 || (subList = listProps.get(i2)) == null) continue;
            CustomGuiProperties[] subArr = subList.toArray(new CustomGuiProperties[subList.size()]);
            cgps[i2] = subArr;
        }
        return cgps;
    }

    private static void update(ul rp, List<List<CustomGuiProperties>> listProps) {
        Object[] paths = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(paths);
        for (int i2 = 0; i2 < paths.length; ++i2) {
            Object name = paths[i2];
            Config.dbg("CustomGuis: " + (String)name);
            try {
                pc locFile = new pc((String)name);
                InputStream in = rp.a(um.a, locFile);
                if (in == null) {
                    Config.warn("CustomGuis file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomGuiProperties cgp = new CustomGuiProperties(props, (String)name);
                if (!cgp.isValid((String)name)) continue;
                CustomGuis.addToList(cgp, listProps);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("CustomGuis file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
            return;
        }
        int indexContainer = cgp.getContainer().ordinal();
        while (listProps.size() <= indexContainer) {
            listProps.add(null);
        }
        List<CustomGuiProperties> subList = listProps.get(indexContainer);
        if (subList == null) {
            subList = new ArrayList<CustomGuiProperties>();
            listProps.set(indexContainer, subList);
        }
        subList.add(cgp);
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

