/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.optifine.Config;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        Map localeProperties = dej.getLocaleProperties();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().aN.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().aN + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources((ul)Config.getDefaultResourcePack(), files, localeProperties);
        ul[] resourcePacks = Config.getResourcePacks();
        for (int i2 = 0; i2 < resourcePacks.length; ++i2) {
            ul rp = resourcePacks[i2];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(ul rp, String[] files, Map localeProperties) {
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                InputStream in;
                String file = files[i2];
                pc loc = new pc(file);
                if (!rp.b(um.a, loc) || (in = rp.a(um.a, loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is, Map localeProperties) throws IOException {
        for (String line : IOUtils.readLines((InputStream)is, (Charset)Charsets.UTF_8)) {
            String[] parts;
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static String get(String key) {
        return dej.a((String)key, (Object[])new Object[0]);
    }

    public static String get(String key, String def) {
        String str = dej.a((String)key, (Object[])new Object[0]);
        if (str == null || str.equals(key)) {
            return def;
        }
        return str;
    }

    public static String getOn() {
        return dej.a((String)"options.on", (Object[])new Object[0]);
    }

    public static String getOff() {
        return dej.a((String)"options.off", (Object[])new Object[0]);
    }

    public static String getFast() {
        return dej.a((String)"options.graphics.fast", (Object[])new Object[0]);
    }

    public static String getFancy() {
        return dej.a((String)"options.graphics.fancy", (Object[])new Object[0]);
    }

    public static String getDefault() {
        return dej.a((String)"generator.default", (Object[])new Object[0]);
    }
}

