/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;

public class ModelUtils {
    private static final Random RANDOM = new Random(0L);

    public static void dbgModel(elo model) {
        if (model == null) {
            return;
        }
        Config.dbg("Model: " + model + ", ao: " + model.a() + ", gui3d: " + model.b() + ", builtIn: " + model.d() + ", particle: " + model.e());
        gc[] faces = gc.n;
        for (int i = 0; i < faces.length; ++i) {
            gc face = faces[i];
            List faceQuads = model.a(null, face, RANDOM);
            ModelUtils.dbgQuads(face.a(), faceQuads, "  ");
        }
        List generalQuads = model.a(null, null, RANDOM);
        ModelUtils.dbgQuads("General", generalQuads, "  ");
    }

    private static void dbgQuads(String name, List quads, String prefix) {
        for (eba quad : quads) {
            ModelUtils.dbgQuad(name, quad, prefix);
        }
    }

    public static void dbgQuad(String name, eba quad, String prefix) {
        Config.dbg(prefix + "Quad: " + quad.getClass().getName() + ", type: " + name + ", face: " + quad.e() + ", tint: " + quad.d() + ", sprite: " + quad.getSprite());
        ModelUtils.dbgVertexData(quad.b(), "  " + prefix);
    }

    public static void dbgVertexData(int[] vd, String prefix) {
        int step = vd.length / 4;
        Config.dbg(prefix + "Length: " + vd.length + ", step: " + step);
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float x2 = Float.intBitsToFloat(vd[pos + 0]);
            float y = Float.intBitsToFloat(vd[pos + 1]);
            float z = Float.intBitsToFloat(vd[pos + 2]);
            int col = vd[pos + 3];
            float u = Float.intBitsToFloat(vd[pos + 4]);
            float v2 = Float.intBitsToFloat(vd[pos + 5]);
            Config.dbg(prefix + i + " xyz: " + x2 + "," + y + "," + z + " col: " + col + " u,v: " + u + "," + v2);
        }
    }

    public static elo duplicateModel(elo model) {
        List generalQuads2 = ModelUtils.duplicateQuadList(model.a(null, null, RANDOM));
        gc[] faces = gc.n;
        HashMap<gc, List> faceQuads2 = new HashMap<gc, List>();
        for (int i = 0; i < faces.length; ++i) {
            gc face = faces[i];
            List quads = model.a(null, face, RANDOM);
            List quads2 = ModelUtils.duplicateQuadList(quads);
            faceQuads2.put(face, quads2);
        }
        elx model2 = new elx(generalQuads2, faceQuads2, model.a(), model.b(), true, model.e(), model.f(), model.g());
        return model2;
    }

    public static List duplicateQuadList(List list) {
        ArrayList<eba> list2 = new ArrayList<eba>();
        for (eba quad : list) {
            eba quad2 = ModelUtils.duplicateQuad(quad);
            list2.add(quad2);
        }
        return list2;
    }

    public static eba duplicateQuad(eba quad) {
        eba quad2 = new eba((int[])quad.b().clone(), quad.d(), quad.e(), quad.getSprite(), quad.f());
        return quad2;
    }
}

