/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.expr;

import java.util.ArrayList;
import java.util.Arrays;
import net.optifine.expr.ExpressionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IParameters;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParametersVariable
implements IParameters {
    private ExpressionType[] first;
    private ExpressionType[] repeat;
    private ExpressionType[] last;
    private int maxCount = Integer.MAX_VALUE;
    private static final ExpressionType[] EMPTY = new ExpressionType[0];

    public ParametersVariable() {
        this(null, null, null);
    }

    public ParametersVariable(ExpressionType[] first, ExpressionType[] repeat, ExpressionType[] last) {
        this(first, repeat, last, Integer.MAX_VALUE);
    }

    public ParametersVariable(ExpressionType[] first, ExpressionType[] repeat, ExpressionType[] last, int maxCount) {
        this.first = ParametersVariable.normalize((ExpressionType[])first);
        this.repeat = ParametersVariable.normalize((ExpressionType[])repeat);
        this.last = ParametersVariable.normalize((ExpressionType[])last);
        this.maxCount = maxCount;
    }

    private static ExpressionType[] normalize(ExpressionType[] exprs) {
        if (exprs == null) {
            return EMPTY;
        }
        return exprs;
    }

    public ExpressionType[] getFirst() {
        return this.first;
    }

    public ExpressionType[] getRepeat() {
        return this.repeat;
    }

    public ExpressionType[] getLast() {
        return this.last;
    }

    public int getCountRepeat() {
        if (this.first == null) {
            return 0;
        }
        return this.first.length;
    }

    public ExpressionType[] getParameterTypes(IExpression[] arguments) {
        int countFixedParams = this.first.length + this.last.length;
        int countVarArgs = arguments.length - countFixedParams;
        int countRepeat = 0;
        int countVarParams = 0;
        while (countVarParams + this.repeat.length <= countVarArgs && countFixedParams + countVarParams + this.repeat.length <= this.maxCount) {
            ++countRepeat;
            countVarParams += this.repeat.length;
        }
        ArrayList<ExpressionType> list = new ArrayList<ExpressionType>();
        list.addAll(Arrays.asList(this.first));
        for (int i2 = 0; i2 < countRepeat; ++i2) {
            list.addAll(Arrays.asList(this.repeat));
        }
        list.addAll(Arrays.asList(this.last));
        ExpressionType[] ets2 = list.toArray(new ExpressionType[list.size()]);
        return ets2;
    }

    public ParametersVariable first(ExpressionType ... first) {
        return new ParametersVariable(first, this.repeat, this.last);
    }

    public ParametersVariable repeat(ExpressionType ... repeat) {
        return new ParametersVariable(this.first, repeat, this.last);
    }

    public ParametersVariable last(ExpressionType ... last) {
        return new ParametersVariable(this.first, this.repeat, last);
    }

    public ParametersVariable maxCount(int maxCount) {
        return new ParametersVariable(this.first, this.repeat, this.last, maxCount);
    }
}

