/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.optifine.Config;
import net.optifine.render.VboRange;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.LinkedList;
import org.lwjgl.PointerBuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public class VboRegion {
    private gfh layer = null;
    private int glArrayObjectId = GlStateManager._glGenVertexArrays();
    private int glBufferId = GlStateManager._glGenBuffers();
    private int capacity = 4096;
    private int positionTop = 0;
    private int sizeUsed;
    private LinkedList<VboRange> rangeList = new LinkedList();
    private VboRange compactRangeLast = null;
    private PointerBuffer bufferIndexVertex = Config.createDirectPointerBuffer((int)this.capacity);
    private IntBuffer bufferCountVertex = Config.createDirectIntBuffer((int)this.capacity);
    private final int vertexBytes = fbg.b.b();
    private fbn.c drawMode = fbn.c.h;
    private boolean isShaders = Config.isShaders();

    public VboRegion(gfh layer) {
        this.layer = layer;
        this.bindBuffer();
        long capacityBytes = this.toBytes(this.capacity);
        GlStateManager._glBufferData((int)GlStateManager.GL_ARRAY_BUFFER, (long)capacityBytes, (int)GlStateManager.GL_STATIC_DRAW);
        this.unbindBuffer();
    }

    public void bufferData(ByteBuffer data, VboRange range) {
        if (this.glBufferId < 0) {
            return;
        }
        int posOld = range.getPosition();
        int sizeOld = range.getSize();
        int sizeNew = this.toVertex((long)data.limit());
        if (sizeNew <= 0) {
            if (posOld >= 0) {
                range.setPosition(-1);
                range.setSize(0);
                this.rangeList.remove(range.getNode());
                this.sizeUsed -= sizeOld;
            }
            return;
        }
        if (sizeNew > sizeOld) {
            range.setPosition(this.positionTop);
            range.setSize(sizeNew);
            this.positionTop += sizeNew;
            if (posOld >= 0) {
                this.rangeList.remove(range.getNode());
            }
            this.rangeList.addLast(range.getNode());
        }
        range.setSize(sizeNew);
        this.sizeUsed += sizeNew - sizeOld;
        this.checkVboSize(range.getPositionNext());
        long positionBytes = this.toBytes(range.getPosition());
        this.bindVertexArray();
        this.bindBuffer();
        GlStateManager.bufferSubData((int)GlStateManager.GL_ARRAY_BUFFER, (long)positionBytes, (ByteBuffer)data);
        this.unbindBuffer();
        VboRegion.unbindVertexArray();
        if (this.positionTop > this.sizeUsed * 11 / 10) {
            this.compactRanges(1);
        }
    }

    private void compactRanges(int countMax) {
        if (this.rangeList.isEmpty()) {
            return;
        }
        VboRange range = this.compactRangeLast;
        if (range == null || !this.rangeList.contains(range.getNode())) {
            range = (VboRange)this.rangeList.getFirst().getItem();
        }
        int posCompact = range.getPosition();
        VboRange rangePrev = range.getPrev();
        posCompact = rangePrev == null ? 0 : rangePrev.getPositionNext();
        for (int count = 0; range != null && count < countMax; ++count) {
            if (range.getPosition() == posCompact) {
                posCompact += range.getSize();
                range = range.getNext();
                continue;
            }
            int sizeFree = range.getPosition() - posCompact;
            if (range.getSize() <= sizeFree) {
                this.copyVboData(range.getPosition(), posCompact, range.getSize());
                range.setPosition(posCompact);
                posCompact += range.getSize();
                range = range.getNext();
                continue;
            }
            this.checkVboSize(this.positionTop + range.getSize());
            this.copyVboData(range.getPosition(), this.positionTop, range.getSize());
            range.setPosition(this.positionTop);
            this.positionTop += range.getSize();
            VboRange rangeNext = range.getNext();
            this.rangeList.remove(range.getNode());
            this.rangeList.addLast(range.getNode());
            range = rangeNext;
        }
        if (range == null) {
            this.positionTop = ((VboRange)this.rangeList.getLast().getItem()).getPositionNext();
        }
        this.compactRangeLast = range;
    }

    private void checkRanges() {
        int count = 0;
        int size = 0;
        for (VboRange range = (VboRange)this.rangeList.getFirst().getItem(); range != null; range = range.getNext()) {
            ++count;
            size += range.getSize();
            if (range.getPosition() < 0 || range.getSize() <= 0 || range.getPositionNext() > this.positionTop) {
                throw new RuntimeException("Invalid range: " + String.valueOf(range));
            }
            VboRange rangePrev = range.getPrev();
            if (rangePrev != null && range.getPosition() < rangePrev.getPositionNext()) {
                throw new RuntimeException("Invalid range: " + String.valueOf(range));
            }
            VboRange rangeNext = range.getNext();
            if (rangeNext == null || range.getPositionNext() <= rangeNext.getPosition()) continue;
            throw new RuntimeException("Invalid range: " + String.valueOf(range));
        }
        if (count != this.rangeList.getSize()) {
            throw new RuntimeException("Invalid count: " + count + " <> " + this.rangeList.getSize());
        }
        if (size != this.sizeUsed) {
            throw new RuntimeException("Invalid size: " + size + " <> " + this.sizeUsed);
        }
    }

    private void checkVboSize(int sizeMin) {
        if (this.capacity < sizeMin) {
            this.expandVbo(sizeMin);
        }
    }

    private void copyVboData(int posFrom, int posTo, int size) {
        long posFromBytes = this.toBytes(posFrom);
        long posToBytes = this.toBytes(posTo);
        long sizeBytes = this.toBytes(size);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_READ_BUFFER, (int)this.glBufferId);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_WRITE_BUFFER, (int)this.glBufferId);
        GlStateManager.copyBufferSubData((int)GlStateManager.GL_COPY_READ_BUFFER, (int)GlStateManager.GL_COPY_WRITE_BUFFER, (long)posFromBytes, (long)posToBytes, (long)sizeBytes);
        Config.checkGlError((String)"Copy VBO range");
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_READ_BUFFER, (int)0);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_WRITE_BUFFER, (int)0);
    }

    private void expandVbo(int sizeMin) {
        int capacityNew = this.capacity * 6 / 4;
        while (capacityNew < sizeMin) {
            capacityNew = capacityNew * 6 / 4;
        }
        long capacityBytes = this.toBytes(this.capacity);
        long capacityNewBytes = this.toBytes(capacityNew);
        int glBufferIdNew = GlStateManager._glGenBuffers();
        GlStateManager._glBindBuffer((int)GlStateManager.GL_ARRAY_BUFFER, (int)glBufferIdNew);
        GlStateManager._glBufferData((int)GlStateManager.GL_ARRAY_BUFFER, (long)capacityNewBytes, (int)GlStateManager.GL_STATIC_DRAW);
        Config.checkGlError((String)"Expand VBO");
        GlStateManager._glBindBuffer((int)GlStateManager.GL_ARRAY_BUFFER, (int)0);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_READ_BUFFER, (int)this.glBufferId);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_WRITE_BUFFER, (int)glBufferIdNew);
        GlStateManager.copyBufferSubData((int)GlStateManager.GL_COPY_READ_BUFFER, (int)GlStateManager.GL_COPY_WRITE_BUFFER, (long)0L, (long)0L, (long)capacityBytes);
        Config.checkGlError((String)("Copy VBO: " + capacityNewBytes));
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_READ_BUFFER, (int)0);
        GlStateManager._glBindBuffer((int)GlStateManager.GL_COPY_WRITE_BUFFER, (int)0);
        GlStateManager._glDeleteBuffers((int)this.glBufferId);
        this.bufferIndexVertex = Config.createDirectPointerBuffer((int)capacityNew);
        this.bufferCountVertex = Config.createDirectIntBuffer((int)capacityNew);
        this.glBufferId = glBufferIdNew;
        this.capacity = capacityNew;
    }

    public void bindVertexArray() {
        GlStateManager._glBindVertexArray((int)this.glArrayObjectId);
    }

    public void bindBuffer() {
        GlStateManager._glBindBuffer((int)GlStateManager.GL_ARRAY_BUFFER, (int)this.glBufferId);
    }

    public void drawArrays(fbn.c drawMode, VboRange range) {
        if (this.drawMode != drawMode) {
            if (this.bufferIndexVertex.position() > 0) {
                throw new IllegalArgumentException("Mixed region draw modes: " + String.valueOf(this.drawMode) + " != " + String.valueOf(drawMode));
            }
            this.drawMode = drawMode;
        }
        int indexSize = 4;
        int pos = drawMode.a(range.getPosition()) * indexSize;
        this.bufferIndexVertex.put((long)pos);
        int count = drawMode.a(range.getSize());
        this.bufferCountVertex.put(count);
    }

    public void finishDraw() {
        this.bindVertexArray();
        this.bindBuffer();
        this.layer.K().g();
        if (this.isShaders) {
            ShadersRender.setupArrayPointersVbo();
        }
        int indexCount = this.drawMode.a(this.positionTop);
        RenderSystem.a rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer((fbn.c)this.drawMode);
        fbn.b indexType = rendersystem$autostorageindexbuffer.a();
        rendersystem$autostorageindexbuffer.b(indexCount);
        this.bufferIndexVertex.flip();
        this.bufferCountVertex.flip();
        GlStateManager.glMultiDrawElements((int)this.drawMode.i, (IntBuffer)this.bufferCountVertex, (int)indexType.c, (PointerBuffer)this.bufferIndexVertex);
        this.bufferIndexVertex.limit(this.bufferIndexVertex.capacity());
        this.bufferCountVertex.limit(this.bufferCountVertex.capacity());
        if (this.positionTop > this.sizeUsed * 11 / 10) {
            this.compactRanges(1);
        }
    }

    public void unbindBuffer() {
        GlStateManager._glBindBuffer((int)GlStateManager.GL_ARRAY_BUFFER, (int)0);
    }

    public static void unbindVertexArray() {
        GlStateManager._glBindVertexArray((int)0);
    }

    public void deleteGlBuffers() {
        if (this.glArrayObjectId >= 0) {
            GlStateManager._glDeleteVertexArrays((int)this.glArrayObjectId);
            this.glArrayObjectId = -1;
        }
        if (this.glBufferId >= 0) {
            GlStateManager._glDeleteBuffers((int)this.glBufferId);
            this.glBufferId = -1;
        }
    }

    private long toBytes(int vertex) {
        return (long)vertex * (long)this.vertexBytes;
    }

    private int toVertex(long bytes) {
        return (int)(bytes / (long)this.vertexBytes);
    }

    public int getPositionTop() {
        return this.positionTop;
    }
}

