/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<ww, ww> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bpl[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bpl[] COLORS_INVALID = new bpl[0];
    private static final ww ANVIL_GUI_TEXTURE = new ww("textures/gui/container/anvil.png");
    private static final ww BEACON_GUI_TEXTURE = new ww("textures/gui/container/beacon.png");
    private static final ww BREWING_STAND_GUI_TEXTURE = new ww("textures/gui/container/brewing_stand.png");
    private static final ww CHEST_GUI_TEXTURE = new ww("textures/gui/container/generic_54.png");
    private static final ww CRAFTING_TABLE_GUI_TEXTURE = new ww("textures/gui/container/crafting_table.png");
    private static final ww HORSE_GUI_TEXTURE = new ww("textures/gui/container/horse.png");
    private static final ww DISPENSER_GUI_TEXTURE = new ww("textures/gui/container/dispenser.png");
    private static final ww ENCHANTMENT_TABLE_GUI_TEXTURE = new ww("textures/gui/container/enchanting_table.png");
    private static final ww FURNACE_GUI_TEXTURE = new ww("textures/gui/container/furnace.png");
    private static final ww HOPPER_GUI_TEXTURE = new ww("textures/gui/container/hopper.png");
    private static final ww INVENTORY_GUI_TEXTURE = new ww("textures/gui/container/inventory.png");
    private static final ww SHULKER_BOX_GUI_TEXTURE = new ww("textures/gui/container/shulker_box.png");
    private static final ww VILLAGER_GUI_TEXTURE = new ww("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bpl[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        bpl[] cols = new bpl[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            bpl col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static bpl parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bpl[] colors = bpl.values();
        for (int i = 0; i < colors.length; ++i) {
            bpl enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static ww parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new ww(basePath + "/" + tex);
    }

    private static Map<ww, ww> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<ww, ww> map = new HashMap<ww, ww>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            ww locKey = CustomGuiProperties.getGuiTextureLocation(container);
            ww locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            ww locKey = new ww(path);
            ww locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static ww getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, gg pos, bws blockAccess) {
        bxo biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.w(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, gg pos, bws blockAccess, eap screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, (bvr)blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, (bvr)blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, (bvr)blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, (bvr)blockAccess);
            }
        }
        return true;
    }

    public static String getName(eap screen) {
        os itc = screen.i();
        if (itc == null) {
            return null;
        }
        return itc.a();
    }

    private boolean matchesBeacon(gg pos, bvr blockAccess) {
        cip te = blockAccess.c_(pos);
        if (!(te instanceof cik)) {
            return false;
        }
        cik teb = (cik)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l2 = Reflector.getFieldValueInt(teb, Reflector.TileEntityBeacon_levels, -1);
            if (!this.levels.isInRange(l2)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(gg pos, bvr blockAccess) {
        cip te = blockAccess.c_(pos);
        if (te instanceof ciu) {
            ciu tec = (ciu)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof cje) {
            cje teec = (cje)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(ciu tec, gg pos, bvr blockAccess) {
        cks blockState = blockAccess.a_(pos);
        clk chestType = blockState.b((clv)cam.c) ? (clk)blockState.c((clv)cam.c) : clk.a;
        boolean isLarge = chestType != clk.a;
        boolean isTrapped = tec instanceof cjx;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(cje teec, gg pos, bvr blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(gg pos, bvr blockAccess) {
        EnumVariant var;
        cip te = blockAccess.c_(pos);
        if (!(te instanceof cjb)) {
            return false;
        }
        cjb ted = (cjb)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(cjb ted) {
        if (ted instanceof cjc) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(gg pos, bvr blockAccess) {
        bpl col;
        cip te = blockAccess.c_(pos);
        if (!(te instanceof cjo)) {
            return false;
        }
        cjo tesb = (cjo)te;
        return this.colors == null || Config.equalsOne(col = tesb.i(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, atf entity, bws blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.cR(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cj())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, (bvr)blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, (bvr)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(atf entity, bvr blockAccess) {
        int level;
        bjr vd;
        bjt vp;
        if (!(entity instanceof bjq)) {
            return false;
        }
        bjq entityVillager = (bjq)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.fG()).b(), level = vd.c(), this.professions);
    }

    private boolean matchesHorse(atf entity, bvr blockAccess) {
        bfl el;
        bpl col;
        EnumVariant var;
        if (!(entity instanceof bfi)) {
            return false;
        }
        bfi ah = (bfi)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof bfl) || Config.equalsOne(col = (el = (bfl)ah).gh(), this.colors);
    }

    private EnumVariant getHorseVariant(bfi entity) {
        if (entity instanceof bfk) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof bfj) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof bfn) {
            return EnumVariant.MULE;
        }
        if (entity instanceof bfl) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public ww getTextureLocation(ww loc) {
        ww locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

