/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static dvo mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static ww getTextureLocation(ww loc) {
        atf entity;
        if (guiProperties == null) {
            return loc;
        }
        eap screen = CustomGuis.mc.z;
        if (!(screen instanceof ebm)) {
            return loc;
        }
        if (!loc.b().equals("minecraft") || !loc.a().startsWith("textures/gui/")) {
            return loc;
        }
        if (playerControllerOF == null) {
            return loc;
        }
        ejh world = CustomGuis.mc.s;
        if (world == null) {
            return loc;
        }
        if (screen instanceof ebz) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.t.cR(), (bws)world, loc, screen);
        }
        if (screen instanceof eci) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.t.cR(), (bws)world, loc, screen);
        }
        gg pos = playerControllerOF.getLastClickBlockPos();
        if (pos != null) {
            if (screen instanceof ebo) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ebp) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ebt) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ebw) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ebx) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, pos, (bws)world, loc, screen);
            }
            if (screen instanceof eca) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ecd) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ece) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ecg) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, pos, (bws)world, loc, screen);
            }
            if (screen instanceof ecr) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, pos, (bws)world, loc, screen);
            }
        }
        if ((entity = playerControllerOF.getLastClickEntity()) != null) {
            if (screen instanceof ech) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, (bws)world, loc);
            }
            if (screen instanceof eco) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, (bws)world, loc);
            }
        }
        return loc;
    }

    private static ww getTexturePos(CustomGuiProperties.EnumContainer container, gg pos, bws blockAccess, ww loc, eap screen) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesPos(container, pos, blockAccess, screen)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    private static ww getTextureEntity(CustomGuiProperties.EnumContainer container, atf entity, bws blockAccess, ww loc) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesEntity(container, entity, blockAccess)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (!Config.isCustomGuis()) {
            return;
        }
        ArrayList<List<CustomGuiProperties>> listProps = new ArrayList<List<CustomGuiProperties>>();
        acv[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            acv rp = rps[i];
            CustomGuis.update(rp, listProps);
        }
        guiProperties = CustomGuis.propertyListToArray(listProps);
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] cgps = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        for (int i = 0; i < cgps.length; ++i) {
            List<CustomGuiProperties> subList;
            if (listProps.size() <= i || (subList = listProps.get(i)) == null) continue;
            CustomGuiProperties[] subArr = subList.toArray(new CustomGuiProperties[subList.size()]);
            cgps[i] = subArr;
        }
        return cgps;
    }

    private static void update(acv rp, List<List<CustomGuiProperties>> listProps) {
        Object[] paths = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(paths);
        for (int i = 0; i < paths.length; ++i) {
            Object name = paths[i];
            Config.dbg("CustomGuis: " + (String)name);
            try {
                ww locFile = new ww((String)name);
                InputStream in = rp.a(acw.a, locFile);
                if (in == null) {
                    Config.warn("CustomGuis file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomGuiProperties cgp = new CustomGuiProperties(props, (String)name);
                if (!cgp.isValid((String)name)) continue;
                CustomGuis.addToList(cgp, listProps);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("CustomGuis file not found: " + (String)name);
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
            return;
        }
        int indexContainer = cgp.getContainer().ordinal();
        while (listProps.size() <= indexContainer) {
            listProps.add(null);
        }
        List<CustomGuiProperties> subList = listProps.get(indexContainer);
        if (subList == null) {
            subList = new ArrayList<CustomGuiProperties>();
            listProps.set(indexContainer, subList);
        }
        subList.add(cgp);
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

