/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private atf entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gg> setLitChunkPos = new HashSet<gg>();
    private gg.a blockPosMutable = new gg.a();

    public DynamicLight(atf entity) {
        this.entity = entity;
        this.offsetY = entity.ct();
    }

    public void update(enf renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.cX() - 0.5;
        double posY = this.entity.cZ() - 0.5 + this.offsetY;
        double posZ = this.entity.dd() - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<gg> setNewPos = new HashSet<gg>();
        if (lightLevel > 0) {
            gl dirX = (aha.b((double)posX) & 0xF) >= 8 ? gl.f : gl.e;
            gl dirY = (aha.b((double)posY) & 0xF) >= 8 ? gl.b : gl.a;
            gl dirZ = (aha.b((double)posZ) & 0xF) >= 8 ? gl.d : gl.c;
            gg chunkPos = new gg(posX, posY, posZ);
            epw.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gg chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            epw.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gg chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            epw.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gg chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            epw.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gg chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            epw.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gg chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            epw.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gg chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            epw.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gg chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            epw.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gg getChunkPos(epw.c renderChunk, gg pos, gl facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(epw.c renderChunk, Set<gg> setPrevPos, Set<gg> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        epw.b compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        gg pos = renderChunk.e().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(enf renderGlobal) {
        for (gg posOld : this.setLitChunkPos) {
            epw.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public atf getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

