/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static final String SUFFIX_PNG = ".png";
    private static final ww LOCATION_TEXTURE_EMPTY = TextureUtils.LOCATION_TEXTURE_EMPTY;
    private static final ww LOCATION_SPRITE_EMPTY = TextureUtils.LOCATION_SPRITE_EMPTY;
    private static exm textureManager;
    private static int countRecursive;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        if (render) {
            ++countRecursive;
            return;
        }
        render = true;
        hasEmissive = false;
    }

    public static ww getEmissiveTexture(ww locationIn) {
        if (!render) {
            return locationIn;
        }
        ewz texture = textureManager.b(locationIn);
        if (texture instanceof exk) {
            return locationIn;
        }
        ww locationEmissive = null;
        if (texture instanceof exh) {
            locationEmissive = ((exh)texture).locationEmissive;
        }
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return locationIn;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_TEXTURE_EMPTY;
        }
        return locationEmissive;
    }

    public static exl getEmissiveSprite(exl sprite) {
        if (!render) {
            return sprite;
        }
        exl spriteEmissive = sprite.spriteEmissive;
        if (!renderEmissive) {
            if (spriteEmissive != null) {
                hasEmissive = true;
            }
            return sprite;
        }
        if (spriteEmissive == null) {
            spriteEmissive = sprite.m().a(LOCATION_SPRITE_EMPTY);
        }
        return spriteEmissive;
    }

    public static eob getEmissiveQuad(eob quad) {
        if (!render) {
            return quad;
        }
        eob quadEmissive = quad.getQuadEmissive();
        if (!renderEmissive) {
            if (quadEmissive != null) {
                hasEmissive = true;
            }
            return quad;
        }
        return quadEmissive;
    }

    public static boolean hasEmissive() {
        if (countRecursive > 0) {
            return false;
        }
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        renderEmissive = true;
    }

    public static boolean isRenderEmissive() {
        return renderEmissive;
    }

    public static void endRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = false;
    }

    public static void endRender() {
        if (countRecursive > 0) {
            --countRecursive;
            return;
        }
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        textureManager = dvo.C().M();
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            ww loc = new ww(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void updateIcons(exk textureMap, Set<ww> locations) {
        if (!active) {
            return;
        }
        for (ww loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(exk textureMap, ww locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.a().endsWith(suffixEm)) {
            return;
        }
        ww locSpriteEm = new ww(locSprite.b(), locSprite.a() + suffixEm);
        ww locPngEm = textureMap.b(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        exl sprite = textureMap.registerSprite(locSprite);
        exl spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void refreshIcons(exk textureMap) {
        Collection sprites = textureMap.getRegisteredSprites();
        for (exl sprite : sprites) {
            EmissiveTextures.refreshIcon(sprite, textureMap);
        }
    }

    private static void refreshIcon(exl sprite, exk textureMap) {
        if (sprite.spriteEmissive == null) {
            return;
        }
        exl spriteNew = textureMap.getUploadedSprite(sprite.l());
        if (spriteNew == null) {
            return;
        }
        exl spriteEmissiveNew = textureMap.getUploadedSprite(sprite.spriteEmissive.l());
        if (spriteEmissiveNew == null) {
            return;
        }
        spriteEmissiveNew.isSpriteEmissive = true;
        spriteNew.spriteEmissive = spriteEmissiveNew;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(ww loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.a().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(ww loc, exh tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.a();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        ww locEmPng = new ww(loc.b(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        countRecursive = 0;
    }
}

