/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.optifine.Config;
import net.optifine.util.MemoryMonitor;

public class Lagometer {
    private static dvo mc;
    private static dvs gameSettings;
    private static apu profiler;
    public static boolean active;
    public static TimerNano timerTick;
    public static TimerNano timerScheduledExecutables;
    public static TimerNano timerChunkUpload;
    public static TimerNano timerChunkUpdate;
    public static TimerNano timerVisibility;
    public static TimerNano timerTerrain;
    public static TimerNano timerServer;
    private static long[] timesFrame;
    private static long[] timesTick;
    private static long[] timesScheduledExecutables;
    private static long[] timesChunkUpload;
    private static long[] timesChunkUpdate;
    private static long[] timesVisibility;
    private static long[] timesTerrain;
    private static long[] timesServer;
    private static boolean[] gcs;
    private static int numRecordedFrameTimes;
    private static long prevFrameTimeNano;
    private static long renderTimeNano;

    public static void updateLagometer() {
        if (mc == null) {
            mc = dvo.C();
            gameSettings = Lagometer.mc.l;
            profiler = mc.aw();
        }
        if (!Lagometer.gameSettings.aR || !Lagometer.gameSettings.ofLagometer && !Lagometer.gameSettings.aT) {
            active = false;
            prevFrameTimeNano = -1L;
            return;
        }
        active = true;
        long timeNowNano = System.nanoTime();
        if (prevFrameTimeNano == -1L) {
            prevFrameTimeNano = timeNowNano;
            return;
        }
        int frameIndex = numRecordedFrameTimes & timesFrame.length - 1;
        ++numRecordedFrameTimes;
        boolean gc = MemoryMonitor.isGcEvent();
        Lagometer.timesFrame[frameIndex] = timeNowNano - prevFrameTimeNano - renderTimeNano;
        Lagometer.timesTick[frameIndex] = Lagometer.timerTick.timeNano;
        Lagometer.timesScheduledExecutables[frameIndex] = Lagometer.timerScheduledExecutables.timeNano;
        Lagometer.timesChunkUpload[frameIndex] = Lagometer.timerChunkUpload.timeNano;
        Lagometer.timesChunkUpdate[frameIndex] = Lagometer.timerChunkUpdate.timeNano;
        Lagometer.timesVisibility[frameIndex] = Lagometer.timerVisibility.timeNano;
        Lagometer.timesTerrain[frameIndex] = Lagometer.timerTerrain.timeNano;
        Lagometer.timesServer[frameIndex] = Lagometer.timerServer.timeNano;
        Lagometer.gcs[frameIndex] = gc;
        Lagometer.timerTick.reset();
        Lagometer.timerScheduledExecutables.reset();
        Lagometer.timerVisibility.reset();
        Lagometer.timerChunkUpdate.reset();
        Lagometer.timerChunkUpload.reset();
        Lagometer.timerTerrain.reset();
        Lagometer.timerServer.reset();
        prevFrameTimeNano = System.nanoTime();
    }

    public static void showLagometer(dqk matrixStackIn, int scaleFactor) {
        if (gameSettings == null) {
            return;
        }
        if (!Lagometer.gameSettings.ofLagometer && !Lagometer.gameSettings.aT) {
            return;
        }
        long timeRenderStartNano = System.nanoTime();
        GlStateManager.clear((int)256);
        RenderSystem.backupProjectionMatrix();
        int displayWidth = mc.aD().k();
        int displayHeight = mc.aD().l();
        d matrix4f = d.a((float)displayWidth, (float)(-displayHeight), (float)1000.0f, (float)3000.0f);
        RenderSystem.setProjectionMatrix((d)matrix4f);
        matrixStackIn.a();
        GlStateManager._disableTexture();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(ena::ap);
        RenderSystem.lineWidth((float)1.0f);
        dqm tess = dqm.a();
        dqf tessellator = tess.c();
        tessellator.a(dqp.b.a, dqi.o);
        for (int frameNum = 0; frameNum < timesFrame.length; ++frameNum) {
            int lum = (frameNum - numRecordedFrameTimes & timesFrame.length - 1) * 100 / timesFrame.length;
            lum += 155;
            float baseHeight = displayHeight;
            long heightFrame = 0L;
            if (gcs[frameNum]) {
                heightFrame = Lagometer.renderTime(frameNum, timesFrame[frameNum], lum, lum / 2, 0, baseHeight, tessellator);
                continue;
            }
            heightFrame = Lagometer.renderTime(frameNum, timesFrame[frameNum], lum, lum, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesServer[frameNum], lum / 2, lum / 2, lum / 2, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesTerrain[frameNum], 0, lum, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesVisibility[frameNum], lum, lum, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesChunkUpdate[frameNum], lum, 0, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesChunkUpload[frameNum], lum, 0, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesScheduledExecutables[frameNum], 0, 0, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesTick[frameNum], 0, lum, lum, baseHeight, tessellator);
        }
        Lagometer.renderTimeDivider(0, timesFrame.length, 33333333L, 196, 196, 196, displayHeight, tessellator);
        Lagometer.renderTimeDivider(0, timesFrame.length, 16666666L, 196, 196, 196, displayHeight, tessellator);
        tess.b();
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._enableTexture();
        int y60 = displayHeight - 80;
        int y30 = displayHeight - 160;
        String str30 = Config.isShowFrameTime() ? "33" : "30";
        String str60 = Config.isShowFrameTime() ? "17" : "60";
        Lagometer.mc.h.b(matrixStackIn, str30, 2.0f, (float)(y30 + 1), -8947849);
        Lagometer.mc.h.b(matrixStackIn, str30, 1.0f, (float)y30, -3881788);
        Lagometer.mc.h.b(matrixStackIn, str60, 2.0f, (float)(y60 + 1), -8947849);
        Lagometer.mc.h.b(matrixStackIn, str60, 1.0f, (float)y60, -3881788);
        RenderSystem.restoreProjectionMatrix();
        matrixStackIn.b();
        float lumMem = 1.0f - (float)((double)(System.currentTimeMillis() - MemoryMonitor.getStartTimeMs()) / 1000.0);
        lumMem = Config.limit(lumMem, 0.0f, 1.0f);
        int memColR = (int)aha.h((float)lumMem, (float)180.0f, (float)255.0f);
        int memColG = (int)aha.h((float)lumMem, (float)110.0f, (float)155.0f);
        int memColB = (int)aha.h((float)lumMem, (float)15.0f, (float)20.0f);
        int colMem = memColR << 16 | memColG << 8 | memColB;
        int posX = 512 / scaleFactor + 2;
        int posY = displayHeight / scaleFactor - 8;
        dwl cfr_ignored_0 = Lagometer.mc.k;
        dwl.a((dqk)matrixStackIn, (int)(posX - 1), (int)(posY - 1), (int)(posX + 50), (int)(posY + 10), (int)-1605349296);
        Lagometer.mc.h.b(matrixStackIn, " " + MemoryMonitor.getAllocationRateMb() + " MB/s", (float)posX, (float)posY, colMem);
        renderTimeNano = System.nanoTime() - timeRenderStartNano;
    }

    private static long renderTime(int frameNum, long time, int r, int g, int b2, float baseHeight, dqf tessellator) {
        long heightTime = time / 200000L;
        if (heightTime < 3L) {
            return 0L;
        }
        tessellator.a((double)((float)frameNum + 0.5f), (double)(baseHeight - (float)heightTime + 0.5f), 0.0).a(r, g, b2, 255).b(0.0f, 1.0f, 0.0f).c();
        tessellator.a((double)((float)frameNum + 0.5f), (double)(baseHeight + 0.5f), 0.0).a(r, g, b2, 255).b(0.0f, 1.0f, 0.0f).c();
        return heightTime;
    }

    private static long renderTimeDivider(int frameStart, int frameEnd, long time, int r, int g, int b2, float baseHeight, dqf tessellator) {
        long heightTime = time / 200000L;
        if (heightTime < 3L) {
            return 0L;
        }
        tessellator.a((double)((float)frameStart + 0.5f), (double)(baseHeight - (float)heightTime + 0.5f), 0.0).a(r, g, b2, 255).b(1.0f, 0.0f, 0.0f).c();
        tessellator.a((double)((float)frameEnd + 0.5f), (double)(baseHeight - (float)heightTime + 0.5f), 0.0).a(r, g, b2, 255).b(1.0f, 0.0f, 0.0f).c();
        return heightTime;
    }

    public static boolean isActive() {
        return active;
    }

    static {
        active = false;
        timerTick = new TimerNano();
        timerScheduledExecutables = new TimerNano();
        timerChunkUpload = new TimerNano();
        timerChunkUpdate = new TimerNano();
        timerVisibility = new TimerNano();
        timerTerrain = new TimerNano();
        timerServer = new TimerNano();
        timesFrame = new long[512];
        timesTick = new long[512];
        timesScheduledExecutables = new long[512];
        timesChunkUpload = new long[512];
        timesChunkUpdate = new long[512];
        timesVisibility = new long[512];
        timesTerrain = new long[512];
        timesServer = new long[512];
        gcs = new boolean[512];
        numRecordedFrameTimes = 0;
        prevFrameTimeNano = -1L;
        renderTimeNano = 0L;
    }

    public static class TimerNano {
        public long timeStartNano = 0L;
        public long timeNano = 0L;

        public void start() {
            if (!active) {
                return;
            }
            if (this.timeStartNano == 0L) {
                this.timeStartNano = System.nanoTime();
            }
        }

        public void end() {
            if (!active) {
                return;
            }
            if (this.timeStartNano != 0L) {
                this.timeNano += System.nanoTime() - this.timeStartNano;
                this.timeStartNano = 0L;
            }
        }

        private void reset() {
            this.timeNano = 0L;
            this.timeStartNano = 0L;
        }
    }
}

