/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static enf renderGlobal;
    private static RandomEntity randomEntity;
    private static epd tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(atf entity, bwp world) {
        if (world == null) {
            return;
        }
        wi edm = entity.ad();
        edm.spawnPosition = entity.cR();
        edm.spawnBiome = world.w(edm.spawnPosition);
        if (entity instanceof bes) {
            bes esr = (bes)entity;
            RandomEntities.checkEntityShoulder(esr, false);
        }
    }

    public static void entityUnloaded(atf entity, bwp world) {
        if (entity instanceof bes) {
            bes esr = (bes)entity;
            RandomEntities.checkEntityShoulder(esr, true);
        }
    }

    private static void checkEntityShoulder(bes entity, boolean attach) {
        att owner = entity.fw();
        if (owner == null) {
            owner = Config.getMinecraft().t;
        }
        if (!(owner instanceof emi)) {
            return;
        }
        emi player = (emi)owner;
        UUID entityUuid = entity.ch();
        if (attach) {
            na nbtRight;
            na nbtLeft = player.fz();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals(nbtLeft.a("UUID"), entityUuid)) {
                player.entityShoulderLeft = entity;
            }
            if ((nbtRight = player.fA()) != null && nbtRight.e("UUID") && Config.equals(nbtRight.a("UUID"), entityUuid)) {
                player.entityShoulderRight = entity;
            }
        } else {
            wi edm = entity.ad();
            if (player.entityShoulderLeft != null && Config.equals(player.entityShoulderLeft.ch(), entityUuid)) {
                wi edmShoulderLeft = player.entityShoulderLeft.ad();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals(player.entityShoulderRight.ch(), entityUuid)) {
                wi edmShoulderRight = player.entityShoulderRight.ad();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(bwp oldWorld, bwp newWorld) {
        if (newWorld instanceof ejh) {
            ejh newWorldClient = (ejh)newWorld;
            Iterable entities = newWorldClient.b();
            for (atf entity : entities) {
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ww getTextureLocation(ww loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re = RandomEntities.getRandomEntityRendered();
            if (re == null) {
                ww ww2 = loc;
                return ww2;
            }
            String name = loc.a();
            if (name.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                name = RandomEntities.getHorseTexturePath(name, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
            }
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY) && !name.startsWith(PREFIX_TEXTURES_PAINTING)) {
                ww ww3 = loc;
                return ww3;
            }
            RandomEntityProperties props = mapProperties.get(name);
            if (props == null) {
                ww ww4 = loc;
                return ww4;
            }
            ww ww5 = props.getTextureLocation(loc, re);
            return ww5;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (epd.tileEntityRendered != null) {
            cip te = epd.tileEntityRendered;
            if (te.k() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(ww loc, boolean optifine) {
        RandomEntityProperties props;
        String path = loc.a();
        ww locProps = RandomEntities.getLocationProperties(loc, optifine);
        if (locProps != null && (props = RandomEntities.parseProperties(locProps, loc)) != null) {
            return props;
        }
        ww[] variants = RandomEntities.getLocationsVariants(loc, optifine);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(ww propLoc, ww resLoc) {
        try {
            String path = propLoc.a();
            RandomEntities.dbg(resLoc.a() + ", properties: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                RandomEntities.warn("Properties not found: " + path);
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rmp = new RandomEntityProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e2) {
            RandomEntities.warn("File not found: " + resLoc.a());
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private static ww getLocationProperties(ww loc, boolean optifine) {
        String path;
        String pathBase;
        String pathProps;
        ww locMcp = RandomEntities.getLocationRandom(loc, optifine);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        ww locProps = new ww(domain, pathProps = (pathBase = StrUtils.removeSuffix(path = locMcp.a(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath(pathBase);
        if (pathParent == null) {
            return null;
        }
        ww locParentProps = new ww(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static ww getLocationRandom(ww loc, boolean optifine) {
        String domain = loc.b();
        String path = loc.a();
        String prefixTextures = PREFIX_TEXTURES;
        String prefixRandom = PREFIX_OPTIFINE_RANDOM;
        if (optifine) {
            prefixTextures = PREFIX_TEXTURES_ENTITY;
            prefixRandom = PREFIX_OPTIFINE_MOB;
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix(path, prefixTextures, prefixRandom);
        return new ww(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        if (pathRandom.startsWith(PREFIX_OPTIFINE_MOB)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_MOB, PREFIX_TEXTURES_ENTITY);
        }
        return null;
    }

    protected static ww getLocationIndexed(ww loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        ww locNew = new ww(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix(path, suffix);
            return pathParent;
        }
        return null;
    }

    private static ww[] getLocationsVariants(ww loc, boolean optifine) {
        ArrayList<ww> list = new ArrayList<ww>();
        list.add(loc);
        ww locRandom = RandomEntities.getLocationRandom(loc, optifine);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            ww locIndex = RandomEntities.getLocationIndexed(locRandom, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        ww[] locs = list.toArray(new ww[list.size()]);
        RandomEntities.dbg(loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = dvo.C().ad();
        String[] prefixes = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_OPTIFINE_MOB};
        String[] suffixes = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] pathsRandom = ResUtils.collectFiles(prefixes, suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            String path = pathsRandom[i2];
            path = StrUtils.removeSuffix(path, suffixes);
            path = StrUtils.trimTrailing(path, "0123456789");
            String pathBase = RandomEntities.getPathBase(path = path + SUFFIX_PNG);
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            ww locBase = new ww(pathBase);
            if (!Config.hasResource(locBase) || (props = mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties(locBase, false);
            if (props == null) {
                props = RandomEntities.makeProperties(locBase, true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, bfk.class, String[].class, 0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, bfk.class, String[].class, 1);
    }
}

