/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<atj, cir> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(atj entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(atj entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cir tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(cir tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight(tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<atj, cir> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<atj, cir> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract egt makeModel();

    public abstract eiq getModelRenderer(egt var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(egt var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, ww textureLocation) {
        return false;
    }

    public eiq[] getModelRenderers(egt model) {
        String[] names = this.getModelRendererNames();
        ArrayList<eiq> list = new ArrayList<eiq>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            eiq mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        eiq[] mrs = list.toArray(new eiq[list.size()]);
        return mrs;
    }

    public static eiq bakeModelLayer(eio loc) {
        return dvo.C().ac().getContext().a(loc);
    }
}

