/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChunkLayerMap<T> {
    private T[] values = new Object[enp.CHUNK_RENDER_TYPES.length];
    private Supplier<T> defaultValue;

    public ChunkLayerMap(Function<enp, T> initialValue) {
        int i2;
        enp[] renderTypes = enp.CHUNK_RENDER_TYPES;
        this.values = new Object[renderTypes.length];
        for (i2 = 0; i2 < renderTypes.length; ++i2) {
            enp renderType = renderTypes[i2];
            T t = initialValue.apply(renderType);
            this.values[renderType.ordinal()] = t;
        }
        for (i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] != null) continue;
            throw new RuntimeException("Missing value at index: " + i2);
        }
    }

    public T get(enp layer) {
        return this.values[layer.ordinal()];
    }

    public Collection<T> values() {
        return Arrays.asList(this.values);
    }
}

