/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<gg> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(gg posStart, gg posEnd, int width, int height) {
        boolean revX = posStart.u() > posEnd.u();
        boolean revY = posStart.v() > posEnd.v();
        boolean revZ = posStart.w() > posEnd.w();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        dna vec = new dna((double)(posEnd.u() - posStart.u()), (double)(posEnd.v() - posStart.v()), (double)(posEnd.w() - posStart.w()));
        dna vecN = vec.d();
        dna vecX = new dna(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        dna vecY = new dna(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        dna vecZ = new dna(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            gg pos1 = new gg(posStart.w(), posStart.v() - width, posStart.u() - height);
            gg pos2 = new gg(posEnd.w(), posStart.v() + width + 1, posStart.u() + height + 1);
            int countX = posEnd.w() - posStart.w();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            gg pos1 = new gg(posStart.v(), posStart.u() - width, posStart.w() - height);
            gg pos2 = new gg(posEnd.v(), posStart.u() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.v() - posStart.v();
            double deltaY = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            gg pos1 = new gg(posStart.u(), posStart.v() - width, posStart.w() - height);
            gg pos2 = new gg(posEnd.u(), posStart.v() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.u() - posStart.u();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private gg reverseCoord(gg pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new gg(-pos.u(), pos.v(), pos.w());
        }
        if (revY) {
            pos = new gg(pos.u(), -pos.v(), pos.w());
        }
        if (revZ) {
            pos = new gg(pos.u(), pos.v(), -pos.w());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public gg next() {
        gg pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.v() * this.kX, pos.u() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.w() * this.kX, pos.v() * this.kY, pos.u() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        gg posStart = new gg(10, 20, 30);
        gg posEnd = new gg(30, 40, 20);
        Iterator3d it = new Iterator3d(posStart, posEnd, 1, 1);
        while (it.hasNext()) {
            gg blockPos = it.next();
            System.out.println("" + blockPos);
        }
    }
}

