/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlBlendState;
import net.optifine.render.GlCullState;
import net.optifine.render.ICamera;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.ClippingHelperDummy;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.GlState;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final ww END_PORTAL_TEXTURE = new ww("textures/entity/end_portal.png");

    public static void setFrustrumPosition(ICamera frustum, double x, double y, double z) {
        frustum.setCameraPosition(x, y, z);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
            Shaders.setRenderStage(RenderStage.TERRAIN_SOLID);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
            Shaders.setRenderStage(RenderStage.TERRAIN_CUTOUT_MIPPED);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
            Shaders.setRenderStage(RenderStage.TERRAIN_CUTOUT);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramWater);
            Shaders.setRenderStage(RenderStage.TERRAIN_TRANSLUCENT);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void beginTripwire() {
        if (Shaders.isRenderingWorld) {
            Shaders.setRenderStage(RenderStage.TRIPWIRE);
        }
    }

    public static void endTripwire() {
        if (Shaders.isRenderingWorld) {
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void renderHand0(ena er, dqk matrixStackIn, duz activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(matrixStackIn, false);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, false);
                Shaders.endHand(matrixStackIn);
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(ena er, dqk matrixStackIn, duz activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            GlStateManager._enableBlend();
            Shaders.beginHand(matrixStackIn, true);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, true);
            Shaders.endHand(matrixStackIn);
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(end itemRenderer, float partialTicks, dqk matrixStackIn, enh.a bufferIn, eml playerEntityIn, int combinedLightIn, boolean renderTranslucent) {
        dvo.C().f.renderedEntity = playerEntityIn;
        GlStateManager._depthMask((boolean)true);
        if (renderTranslucent) {
            GlStateManager._depthFunc((int)519);
            matrixStackIn.a();
            DrawBuffers drawBuffers = GlState.getDrawBuffers();
            GlState.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
            Shaders.renderItemKeepDepthMask = false;
            GlState.setDrawBuffers(drawBuffers);
            matrixStackIn.b();
        }
        GlStateManager._depthFunc((int)515);
        itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
        dvo.C().f.renderedEntity = null;
    }

    public static void renderFPOverlay(ena er, dqk matrixStackIn, duz activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            Shaders.setRenderStage(RenderStage.DESTROY);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                GlState.setDrawBuffers(Shaders.drawBuffersColorAtt[0]);
                GlStateManager._depthMask((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            GlStateManager._depthMask((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void beginOutline() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramBasic);
            Shaders.setRenderStage(RenderStage.OUTLINE);
        }
    }

    public static void endOutline() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void beginDebug() {
        if (Shaders.isRenderingWorld) {
            Shaders.setRenderStage(RenderStage.DEBUG);
        }
    }

    public static void endDebug() {
        if (Shaders.isRenderingWorld) {
            Shaders.setRenderStage(RenderStage.NONE);
        }
    }

    public static void renderShadowMap(ena entityRenderer, duz activeRenderInfo, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.hasShadowMap) {
            dvo mc = dvo.C();
            mc.aw().b("shadow pass");
            enf renderGlobal = mc.f;
            Shaders.isShadowPass = true;
            Shaders.updateProjectionMatrix();
            Shaders.checkGLError("pre shadow");
            d projectionPrev = RenderSystem.getProjectionMatrix();
            RenderSystem.getModelViewStack().a();
            mc.aw().b("shadow clear");
            Shaders.sfb.bindFramebuffer();
            Shaders.checkGLError("shadow bind sfb");
            mc.aw().b("shadow camera");
            ShadersRender.updateActiveRenderInfo(activeRenderInfo, mc, partialTicks);
            dqk matrixStack = new dqk();
            Shaders.setCameraShadow(matrixStack, activeRenderInfo, partialTicks);
            d projectionMatrix = RenderSystem.getProjectionMatrix();
            Shaders.checkGLError("shadow camera");
            Shaders.dispatchComputes(Shaders.dfb, Shaders.ProgramShadow.getComputePrograms());
            Shaders.useProgram(Shaders.ProgramShadow);
            Shaders.sfb.setDrawBuffers();
            Shaders.checkGLError("shadow drawbuffers");
            GL30.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            Shaders.sfb.setDepthTexture();
            Shaders.sfb.setColorTextures(true);
            Shaders.checkFramebufferStatus("shadow fb");
            GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.clear((int)256);
            for (int i2 = 0; i2 < Shaders.usedShadowColorBuffers; ++i2) {
                if (!Shaders.shadowBuffersClear[i2]) continue;
                l col = Shaders.shadowBuffersClearColor[i2];
                if (col != null) {
                    GlStateManager._clearColor((float)col.a(), (float)col.b(), (float)col.c(), (float)col.d());
                } else {
                    GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlState.setDrawBuffers(Shaders.drawBuffersColorAtt[i2]);
                GlStateManager.clear((int)16384);
            }
            Shaders.sfb.setDrawBuffers();
            Shaders.checkGLError("shadow clear");
            mc.aw().b("shadow frustum");
            ClippingHelperDummy frustum = new ClippingHelperDummy();
            mc.aw().b("shadow culling");
            dna cameraPos = activeRenderInfo.b();
            frustum.a(cameraPos.b, cameraPos.c, cameraPos.d);
            GlStateManager._enableDepthTest();
            GlStateManager._depthFunc((int)515);
            GlStateManager._depthMask((boolean)true);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.lockCull((GlCullState)new GlCullState(false));
            GlStateManager.lockBlend((GlBlendState)new GlBlendState(false));
            mc.aw().b("shadow prepareterrain");
            mc.M().a(exk.e);
            mc.aw().b("shadow setupterrain");
            int frameCount = mc.f.getNextFrameCount();
            renderGlobal.a(activeRenderInfo, (eqb)frustum, false, frameCount, mc.t.A_());
            mc.aw().b("shadow updatechunks");
            mc.aw().b("shadow terrain");
            double x = cameraPos.a();
            double y = cameraPos.b();
            double z = cameraPos.c();
            if (Shaders.isRenderShadowTerrain()) {
                GlStateManager.disableAlphaTest();
                renderGlobal.a(RenderTypes.SOLID, matrixStack, x, y, z, projectionMatrix);
                Shaders.checkGLError("shadow terrain solid");
                GlStateManager.enableAlphaTest();
                renderGlobal.a(RenderTypes.CUTOUT_MIPPED, matrixStack, x, y, z, projectionMatrix);
                Shaders.checkGLError("shadow terrain cutoutmipped");
                mc.M().b(exk.e).a(false, false);
                renderGlobal.a(RenderTypes.CUTOUT, matrixStack, x, y, z, projectionMatrix);
                mc.M().b(exk.e).restoreLastBlurMipmap();
                Shaders.checkGLError("shadow terrain cutout");
            }
            mc.aw().b("shadow entities");
            enf wr = mc.f;
            erv renderManager = mc.ac();
            enh.a irendertypebuffer = wr.getRenderTypeTextures().b();
            boolean playerShadowPass = Shaders.isShadowPass && !mc.t.A_();
            Iterable entities = Shaders.isRenderShadowEntities() ? Shaders.getCurrentWorld().b() : Collections.EMPTY_LIST;
            for (atf entity : entities) {
                if (!renderManager.a(entity, (eqb)frustum, x, y, z) && !entity.w((atf)mc.t) || entity == activeRenderInfo.g() && !playerShadowPass && !activeRenderInfo.i() && (!(activeRenderInfo.g() instanceof att) || !((att)activeRenderInfo.g()).eU()) || entity instanceof eml && activeRenderInfo.g() != entity) continue;
                wr.renderedEntity = entity;
                Shaders.nextEntity(entity);
                wr.a(entity, x, y, z, partialTicks, matrixStack, (enh)irendertypebuffer);
                wr.renderedEntity = null;
            }
            irendertypebuffer.a();
            wr.a(matrixStack);
            irendertypebuffer.a(enp.b((ww)exk.e));
            irendertypebuffer.a(enp.c((ww)exk.e));
            irendertypebuffer.a(enp.d((ww)exk.e));
            irendertypebuffer.a(enp.i((ww)exk.e));
            Shaders.endEntities();
            Shaders.beginBlockEntities();
            epp.updateTextRenderDistance();
            boolean forgeRenderBoundingBox = Reflector.IForgeTileEntity_getRenderBoundingBox.exists();
            ClippingHelperDummy camera = frustum;
            List renderInfosTileEntities = Shaders.isRenderShadowBlockEntities() ? wr.getRenderInfosTileEntities() : Collections.EMPTY_LIST;
            for (enf.a worldrenderer$localrenderinformationcontainer : renderInfosTileEntities) {
                List list = worldrenderer$localrenderinformationcontainer.a.c().b();
                if (list.isEmpty()) continue;
                for (cip tileentity1 : list) {
                    dmv aabb;
                    if (forgeRenderBoundingBox && (aabb = (dmv)Reflector.call(tileentity1, Reflector.IForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !camera.a(aabb)) continue;
                    Shaders.nextBlockEntity(tileentity1);
                    gg blockpos3 = tileentity1.m();
                    matrixStack.a();
                    matrixStack.a((double)blockpos3.u() - x, (double)blockpos3.v() - y, (double)blockpos3.w() - z);
                    mc.ad().a(tileentity1, partialTicks, matrixStack, (enh)irendertypebuffer);
                    matrixStack.b();
                }
            }
            wr.a(matrixStack);
            irendertypebuffer.a(enp.c());
            irendertypebuffer.a(ent.g());
            irendertypebuffer.a(ent.h());
            irendertypebuffer.a(ent.c());
            irendertypebuffer.a(ent.d());
            irendertypebuffer.a(ent.e());
            irendertypebuffer.a(ent.f());
            irendertypebuffer.b();
            Shaders.endBlockEntities();
            Shaders.checkGLError("shadow entities");
            GlStateManager._depthMask((boolean)true);
            GlStateManager._disableBlend();
            GlStateManager.unlockCull();
            GlStateManager._enableCull();
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                GlStateManager._activeTexture((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                GlStateManager._activeTexture((int)33984);
            }
            GlStateManager._disableBlend();
            GlStateManager._depthMask((boolean)true);
            mc.M().a(exk.e);
            Shaders.checkGLError("shadow pre-translucent");
            Shaders.sfb.setDrawBuffers();
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.aw().b("shadow translucent");
                renderGlobal.a(RenderTypes.TRANSLUCENT, matrixStack, x, y, z, projectionMatrix);
                Shaders.checkGLError("shadow translucent");
            }
            GlStateManager.unlockBlend();
            GlStateManager._depthMask((boolean)true);
            GlStateManager._enableCull();
            GlStateManager._disableBlend();
            GL30.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.aw().b("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                Shaders.sfb.generateDepthMipmaps(Shaders.shadowMipmapEnabled);
                Shaders.sfb.generateColorMipmaps(true, Shaders.shadowColorMipmapEnabled);
            }
            Shaders.checkGLError("shadow postprocess");
            if (Shaders.hasShadowcompPrograms) {
                Shaders.renderShadowComposites();
            }
            Shaders.dfb.bindFramebuffer();
            GlStateManager._viewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            GlState.setDrawBuffers(null);
            mc.M().a(exk.e);
            Shaders.useProgram(Shaders.ProgramTerrain);
            RenderSystem.getModelViewStack().b();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setProjectionMatrix((d)projectionPrev);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void updateActiveRenderInfo(duz activeRenderInfo, dvo mc, float partialTicks) {
        activeRenderInfo.a((bvt)mc.s, (atf)(mc.aa() == null ? mc.t : mc.aa()), !mc.l.f().a(), mc.l.f().b(), partialTicks);
    }

    public static void preRenderChunkLayer(enp blockLayerIn) {
        if (blockLayerIn == RenderTypes.SOLID) {
            ShadersRender.beginTerrainSolid();
        }
        if (blockLayerIn == RenderTypes.CUTOUT_MIPPED) {
            ShadersRender.beginTerrainCutoutMipped();
        }
        if (blockLayerIn == RenderTypes.CUTOUT) {
            ShadersRender.beginTerrainCutout();
        }
        if (blockLayerIn == RenderTypes.TRANSLUCENT) {
            ShadersRender.beginTranslucent();
        }
        if (blockLayerIn == enp.s()) {
            ShadersRender.beginTripwire();
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager._disableCull();
        }
        if (GLX.useVbo()) {
            GL20.glEnableVertexAttribArray((int)Shaders.midBlockAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(enp blockLayerIn) {
        if (GLX.useVbo()) {
            GL20.glDisableVertexAttribArray((int)Shaders.midBlockAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager._enableCull();
        }
    }

    public static void preRender(enp renderType, dqf buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintBegin();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.beginSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.beginBlockDamage();
        } else if (renderType == enp.aN || renderType == enp.aO) {
            Shaders.beginLines();
        }
    }

    public static void postRender(enp renderType, dqf buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintEnd();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.endSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.endBlockDamage();
        } else if (renderType == enp.aN || renderType == enp.aO) {
            Shaders.endLines();
        }
    }

    public static void enableArrayPointerVbo() {
        GL20.glEnableVertexAttribArray((int)Shaders.midBlockAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
        GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 18;
        GL20.glVertexAttribPointer((int)Shaders.midBlockAttrib, (int)3, (int)5120, (boolean)false, (int)72, (long)32L);
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)72, (long)36L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)72, (long)44L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)72, (long)52L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        GlStateManager._disableBlend();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(cjv te, float partialTicks, float offset, dqk matrixStackIn, enh bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float zn;
        float yn;
        float xn;
        float zv;
        float yv;
        float xv;
        hb vec3i;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        dqk.a matrixEntry = matrixStackIn.c();
        d matrix = matrixEntry.a();
        c matrixNormal = matrixEntry.b();
        dqo bufferbuilder = bufferIn.getBuffer(enp.b((ww)END_PORTAL_TEXTURE));
        float col = 0.5f;
        float r = col * 0.15f;
        float g2 = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lm = combinedLightIn;
        int ov2 = combinedOverlayIn;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (te.a(gl.d)) {
            vec3i = gl.d.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y + 1.0f, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        if (te.a(gl.c)) {
            vec3i = gl.c.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y + 1.0f, z).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        if (te.a(gl.f)) {
            vec3i = gl.f.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        if (te.a(gl.e)) {
            vec3i = gl.e.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y + 1.0f, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y + 1.0f, z).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        if (te.a(gl.a)) {
            vec3i = gl.a.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        if (te.a(gl.b)) {
            vec3i = gl.b.p();
            xv = vec3i.u();
            yv = vec3i.v();
            zv = vec3i.w();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y + dy, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y + dy, z + 1.0f).a(r, g2, b2, 1.0f).a(u0 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x + 1.0f, y + dy, z).a(r, g2, b2, 1.0f).a(u1 + du, v1 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
            bufferbuilder.a(matrix, x, y + dy, z).a(r, g2, b2, 1.0f).a(u1 + du, v0 + dv).b(ov2).a(lm).b(xn, yn, zn).c();
        }
        return true;
    }
}

