/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private biq entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gw> setLitChunkPos = new HashSet();
    private gw.a blockPosMutable = new gw.a();

    public DynamicLight(biq entity) {
        this.entity = entity;
        this.offsetY = entity.cH();
    }

    public void update(foc renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dq() - 0.5;
        double posY = this.entity.ds() - 0.5 + this.offsetY;
        double posZ = this.entity.dw() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((biq)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            ha dirX = (arw.a((double)posX) & 0xF) >= 8 ? ha.f : ha.e;
            ha dirY = (arw.a((double)posY) & 0xF) >= 8 ? ha.b : ha.a;
            ha dirZ = (arw.a((double)posZ) & 0xF) >= 8 ? ha.d : ha.c;
            gw chunkPos = gw.a((double)posX, (double)posY, (double)posZ);
            frc.b chunk = renderGlobal.getRenderChunk(chunkPos);
            gw chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            frc.b chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gw chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            frc.b chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gw chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            frc.b chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gw chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            frc.b chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gw chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            frc.b chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gw chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            frc.b chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gw chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            frc.b chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gw getChunkPos(frc.b renderChunk, gw pos, ha facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(frc.b renderChunk, Set<gw> setPrevPos, Set<gw> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        frc.a compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gw pos = renderChunk.f().i();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(foc renderGlobal) {
        for (gw posOld : this.setLitChunkPos) {
            frc.b chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public biq getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

