/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.config.ConnectedParser;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private boolean raw = false;
    private int type = 0;
    private String value = null;
    private Pattern valueRegex = null;
    private RangeListInt valueRange = null;
    private int valueFormat = 0;
    private static final int TYPE_INVALID = -1;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final int TYPE_RANGE = 5;
    private static final int TYPE_EXISTS = 6;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final String PREFIX_RAW = "raw:";
    private static final String PREFIX_RANGE = "range:";
    private static final String PREFIX_EXISTS = "exists:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize((String)tag, (String)".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith("raw:")) {
            this.raw = true;
            value = value.substring("raw:".length());
        }
        if (value.startsWith("pattern:")) {
            this.type = 1;
            if ((value = value.substring("pattern:".length())).equals("*")) {
                this.type = 6;
            }
        } else if (value.startsWith("ipattern:")) {
            this.type = 2;
            if ((value = value.substring("ipattern:".length()).toLowerCase()).equals("*")) {
                this.type = 6;
            }
        } else if (value.startsWith("regex:")) {
            this.type = 3;
            value = value.substring("regex:".length());
            this.valueRegex = Pattern.compile(value);
            if (value.equals(".*")) {
                this.type = 6;
            }
        } else if (value.startsWith("iregex:")) {
            this.type = 4;
            value = value.substring("iregex:".length());
            this.valueRegex = Pattern.compile(value, 2);
            if (value.equals(".*")) {
                this.type = 6;
            }
        } else if (value.startsWith("range:")) {
            this.type = 5;
            value = value.substring("range:".length());
            ConnectedParser cp = new ConnectedParser("NbtTag");
            this.valueRange = cp.parseRangeListIntNeg(value);
            if (this.valueRange == null) {
                Config.warn((String)("Invalid range: " + value));
                this.type = -1;
                this.negative = false;
            }
        } else if (value.startsWith("exists:")) {
            this.type = 6;
            Boolean valB = Config.parseBoolean((String)(value = value.substring("exists:".length())), null);
            if (Config.isFalse((Boolean)valB)) {
                boolean bl = this.negative = !this.negative;
            }
            if (valB == null) {
                Config.warn((String)("Invalid exists: " + value));
                this.type = -1;
                this.negative = false;
            }
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(qw nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(qw nbt) {
        if (nbt == null) {
            return false;
        }
        qw tagBase = nbt;
        for (int i = 0; i < this.parents.length; ++i) {
            String tag = this.parents[i];
            if ((tagBase = NbtTagValue.getChildTag((rq)tagBase, (String)tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((rq)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((rq)tagBase, (String)this.name)) == null) {
            return false;
        }
        return this.matchesBase((rq)tagBase);
    }

    private boolean matchesAnyChild(rq tagBase) {
        if (tagBase instanceof qw) {
            qw tagCompound = (qw)tagBase;
            Set nbtKeySet = tagCompound.e();
            for (String key : nbtKeySet) {
                rq nbtBase = tagCompound.c(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof rc) {
            rc tagList = (rc)tagBase;
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                rq nbtBase = tagList.k(i);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static rq getChildTag(rq tagBase, String tag) {
        if (tagBase instanceof qw) {
            qw tagCompound = (qw)tagBase;
            return tagCompound.c(tag);
        }
        if (tagBase instanceof rc) {
            rc tagList = (rc)tagBase;
            if (tag.equals("count")) {
                return rb.a((int)tagList.size());
            }
            int index = Config.parseInt((String)tag, (int)-1);
            if (index < 0 || index >= tagList.size()) {
                return null;
            }
            return tagList.k(index);
        }
        return null;
    }

    public boolean matchesBase(rq nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        switch (this.type) {
            case -1: {
                return false;
            }
            case 5: {
                int nbtValueInt = NbtTagValue.getNbtInt((rq)nbtBase, (int)Integer.MIN_VALUE);
                if (nbtValueInt != Integer.MIN_VALUE) {
                    return NbtTagValue.matchesRange((int)nbtValueInt, (RangeListInt)this.valueRange);
                }
            }
            case 6: {
                return true;
            }
        }
        String nbtValue = this.raw ? String.valueOf(nbtBase) : NbtTagValue.getNbtString((rq)nbtBase, (int)this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case -1: {
                return false;
            }
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return NbtTagValue.matchesPattern((String)nbtValue, (String)this.value);
            }
            case 2: {
                return NbtTagValue.matchesPattern((String)nbtValue.toLowerCase(), (String)this.value);
            }
            case 3: 
            case 4: {
                return NbtTagValue.matchesRegex((String)nbtValue, (Pattern)this.valueRegex);
            }
            case 5: {
                return NbtTagValue.matchesRange((String)nbtValue, (RangeListInt)this.valueRange);
            }
            case 6: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private static boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask((String)str, (String)pattern, (char)'*', (char)'?');
    }

    private static boolean matchesRegex(String str, Pattern regex) {
        return regex.matcher(str).matches();
    }

    private static boolean matchesRange(String str, RangeListInt range) {
        if (range == null) {
            return false;
        }
        int valInt = Config.parseInt((String)str, (int)Integer.MIN_VALUE);
        if (valInt == Integer.MIN_VALUE) {
            return false;
        }
        return NbtTagValue.matchesRange((int)valInt, (RangeListInt)range);
    }

    private static boolean matchesRange(int valInt, RangeListInt range) {
        if (range == null) {
            return false;
        }
        return range.isInRange(valInt);
    }

    private static String getNbtString(rq nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof ro) {
            ro nbtString = (ro)nbtBase;
            String text = nbtString.r_();
            if (text.startsWith("{") && text.endsWith("}")) {
                text = NbtTagValue.getMergedJsonText((String)text);
            } else if (text.startsWith("[{") && text.endsWith("}]")) {
                text = NbtTagValue.getMergedJsonText((String)text);
            }
            return text;
        }
        if (nbtBase instanceof rb) {
            rb i = (rb)nbtBase;
            if (format == 1) {
                return "#" + StrUtils.fillLeft((String)Integer.toHexString(i.g()), (int)6, (char)'0');
            }
            return Integer.toString(i.g());
        }
        if (nbtBase instanceof qu) {
            qu b2 = (qu)nbtBase;
            return Byte.toString(b2.i());
        }
        if (nbtBase instanceof rl) {
            rl s = (rl)nbtBase;
            return Short.toString(s.h());
        }
        if (nbtBase instanceof re) {
            re l2 = (re)nbtBase;
            return Long.toString(l2.f());
        }
        if (nbtBase instanceof qz) {
            qz f = (qz)nbtBase;
            return Float.toString(f.k());
        }
        if (nbtBase instanceof qx) {
            qx d = (qx)nbtBase;
            return Double.toString(d.j());
        }
        return nbtBase.toString();
    }

    private static int getNbtInt(rq nbtBase, int defVal) {
        if (nbtBase == null) {
            return defVal;
        }
        if (nbtBase instanceof rb) {
            rb i = (rb)nbtBase;
            return i.g();
        }
        if (nbtBase instanceof qu) {
            qu b2 = (qu)nbtBase;
            return b2.i();
        }
        if (nbtBase instanceof rl) {
            rl s = (rl)nbtBase;
            return s.h();
        }
        if (nbtBase instanceof re) {
            re l2 = (re)nbtBase;
            return (int)l2.f();
        }
        if (nbtBase instanceof qz) {
            qz f = (qz)nbtBase;
            return (int)f.k();
        }
        if (nbtBase instanceof qx) {
            qx d = (qx)nbtBase;
            return (int)d.j();
        }
        return defVal;
    }

    private static String getMergedJsonText(String text) {
        StringBuilder sb = new StringBuilder();
        String TOKEN_TEXT = "\"text\":\"";
        int pos = -1;
        while ((pos = text.indexOf(TOKEN_TEXT, pos + 1)) >= 0) {
            String str = NbtTagValue.parseString((String)text, (int)(pos + TOKEN_TEXT.length()));
            if (str == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static String parseString(String text, int pos) {
        StringBuilder sb = new StringBuilder();
        boolean escapeMode = false;
        for (int i = pos; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (escapeMode) {
                if (ch == 'b') {
                    sb.append('\b');
                } else if (ch == 'f') {
                    sb.append('\f');
                } else if (ch == 'n') {
                    sb.append('\n');
                } else if (ch == 'r') {
                    sb.append('\r');
                } else if (ch == 't') {
                    sb.append('\t');
                } else {
                    sb.append(ch);
                }
                escapeMode = false;
                continue;
            }
            if (ch == '\\') {
                escapeMode = true;
                continue;
            }
            if (ch == '\"') break;
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parents.length; ++i) {
            String parent = this.parents[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

