/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<biu, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<dcx, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Map<biu, ftg> originalEntityRenderMap;
    private static Map<dcx, fqe> originalTileEntityRenderMap;
    private static Map<czx.a, fha> originalSkullModelMap;
    private static List<dcx> customTileEntityTypes;
    private static fem customBookModel;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        fnr blockEntityRenderer = eqv.O().aq().getBlockEntityRenderer();
        blockEntityRenderer.k = new fhi(ModelAdapter.bakeModelLayer((fia)fib.bC));
        fxm.customParrotModel = null;
        customBookModel = null;
        fqe.CACHED_TYPES.clear();
        if (eqv.O().r != null) {
            Iterable entities = eqv.O().r.e();
            for (biq entity : entities) {
                Map modelVariables = entity.al().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        aew[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            aew loc = locs[i];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc2 = CustomEntityModels.parseEntityRender((aew)loc, (RendererCache)rendererCache, (int)0);
            if (rc2 == null) continue;
            Either type = rc2.getType();
            if (rc2 instanceof ftg) {
                fut pr;
                fgd pm;
                fvt tr;
                fhi tm;
                entityRenderMap.put((biu)type.getLeft().get(), (ftg)rc2);
                rendererCache.put((biu)type.getLeft().get(), 0, (ftg)rc2);
                if (rc2 instanceof fvt && (tm = (fhi)Reflector.getFieldValue((Object)(tr = (fvt)rc2), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.k = tm;
                }
                if (rc2 instanceof fut && (pm = (fgd)(pr = (fut)rc2).a()) != null) {
                    fxm.customParrotModel = pm;
                }
            } else if (rc2 instanceof fqe) {
                tileEntityRenderMap.put((dcx)type.getRight().get(), (fqe)rc2);
                rendererCache.put((dcx)type.getRight().get(), 0, (fqe)rc2);
                if (rc2 instanceof fqn) {
                    fqn etr = (fqn)rc2;
                    fem bm = (fem)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((fem)bm);
                }
                customTileEntityTypes.add((dcx)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc2.getClass().getName()));
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (RandomEntityContext.Models)context);
            if (props == null) {
                props = CustomEntityModels.makeProperties((String)(name + "/" + name), (RandomEntityContext.Models)context);
            }
            if (props == null) continue;
            if (type.getLeft().isPresent()) {
                mapEntityProperties.put((biu)type.getLeft().get(), props);
                continue;
            }
            mapBlockEntityProperties.put((dcx)type.getRight().get(), props);
        }
    }

    private static RandomEntityProperties makeProperties(String name, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        aew locJem = new aew("optifine/cem/" + name + ".jem");
        aew locProps = new aew("optifine/cem/" + name + ".properties");
        if (Config.hasResource((aew)locProps) && (props = RandomEntityProperties.parse((aew)locProps, (aew)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((aew)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((aew)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(locJem.a(), locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    private static void setEnchantmentScreenBookModel(fem bookModel) {
        customBookModel = bookModel;
    }

    private static Map<biu, ftg> getEntityRenderMap() {
        ftf rm = eqv.O().ao();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<dcx, fqe> getTileEntityRenderMap() {
        fqd blockEntityRenderDispatcher = eqv.O().ap();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<czx.a, fha> getSkullModelMap() {
        HashMap skullModelMap = fqt.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static aew[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<aew> resourceLocations = new ArrayList<aew>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            aew loc = new aew(path);
            if (!Config.hasResource((aew)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        aew[] locs = resourceLocations.toArray(new aew[resourceLocations.size()]);
        return locs;
    }

    public static IEntityRenderer parseEntityRender(aew location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((aew)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((aew)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a(), (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(aew loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        ffz model = ma.makeModel();
        cht[] colors = cht.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            fic part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            cht col = colors[(i + offset) % colors.length];
            aew locTexture = new aew("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize(), rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        name = StrUtils.trimTrailing((String)name, (String)"0123456789");
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        ffz model;
        aew textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (ffz)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (ffz)model, (IEntityRenderer)r, (aew)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, ffz model, IEntityRenderer er, aew textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof fui) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (ffz)model, (aew)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, ffz model, aew textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            fic modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, ffz model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (ffz)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, ffz model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        fic parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                fic[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    fic mr = (fic)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(dfj blockStateIn) {
        for (int i = 0; i < customTileEntityTypes.size(); ++i) {
            dcx type = (dcx)customTileEntityTypes.get(i);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(eyk screen) {
        if (customBookModel != null && screen instanceof fab) {
            fab es = (fab)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static ftg getEntityRenderer(biq entityIn, ftg renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((biq)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.ag());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof ftg)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        ftg er = (ftg)ier;
        return er;
    }

    public static fqe getBlockEntityRenderer(dcv entityIn, fqe renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((dcv)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.u());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fqe)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fqe ber = (fqe)ier;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        originalEntityRenderMap = null;
        originalTileEntityRenderMap = null;
        originalSkullModelMap = null;
        customTileEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

