/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.RendererCache;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<biu, dcx> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(biu entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(biu entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(dcx tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(dcx tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<biu, dcx> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<biu, dcx> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract ffz makeModel();

    public abstract fic getModelRenderer(ffz var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(ffz var1, float var2, RendererCache var3, int var4);

    public boolean setTextureLocation(IEntityRenderer er, aew textureLocation) {
        return false;
    }

    public fic[] getModelRenderers(ffz model) {
        String[] names = this.getModelRendererNames();
        ArrayList<fic> list = new ArrayList<fic>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            fic mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        fic[] mrs = list.toArray(new fic[list.size()]);
        return mrs;
    }

    public static fic bakeModelLayer(fia loc) {
        return eqv.O().ao().getContext().a(loc);
    }
}

