/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.Config;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.EntityVariableBool;
import net.optifine.entity.model.anim.EntityVariableFloat;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IModelVariable;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.entity.model.anim.RendererVariableFloat;
import net.optifine.expr.IExpression;
import net.optifine.util.Either;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private ffz model;
    private CustomModelRenderer[] customModelRenderers;
    private fic thisModelRenderer;
    private fic partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, ffz model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Either type = modelAdapter.getType();
        this.renderResolver = type.getRight().isPresent() ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    public IExpression getExpression(String name) {
        IModelVariable mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression param = this.renderResolver.getParameter(name);
        if (param != null) {
            return param;
        }
        return null;
    }

    public fic getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize((String)name, (String)":");
            fic mr = this.getModelRenderer(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                fic mrSub = mr.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr = mrSub;
            }
            return mr;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        fic mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i = 0; i < this.customModelRenderers.length; ++i) {
            CustomModelRenderer cmr = this.customModelRenderers[i];
            fic mr = cmr.getModelRenderer();
            if (name.equals(mr.getId())) {
                return mr;
            }
            fic mrChild = mr.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    public IModelVariable getModelVariable(String name) {
        String[] parts = Config.tokenize((String)name, (String)".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        if (modelName.equals("var") && !this.renderResolver.isTileEntity()) {
            return new EntityVariableFloat(name);
        }
        if (modelName.equals("varb") && !this.renderResolver.isTileEntity()) {
            return new EntityVariableBool(name);
        }
        if (modelName.equals("render")) {
            if (!this.renderResolver.isTileEntity()) {
                return RendererVariableFloat.parse((String)varName);
            }
            return null;
        }
        fic mr = this.getModelRenderer(modelName);
        if (mr == null) {
            return null;
        }
        ModelVariableType varType = ModelVariableType.parse((String)varName);
        if (varType == null) {
            return null;
        }
        IModelVariable var = varType.makeModelVariable(name, mr);
        return var;
    }

    public void setPartModelRenderer(fic partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(fic thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

