/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.optifine.Config;
import net.optifine.util.GpuMemory;
import net.optifine.util.MathUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebugUtils {
    private static FloatBuffer floatBuffer16 = BufferUtils.createFloatBuffer((int)16);
    private static float[] floatArray16 = new float[16];

    public static String getGlModelView() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2982, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    public static String getGlProjection() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2983, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    private static float[] transposeMat4(float[] arr) {
        float[] arrT = new float[16];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                arrT[x * 4 + y] = arr[y * 4 + x];
            }
        }
        return arrT;
    }

    public static String getMatrix4(Matrix4f mat) {
        MathUtils.write((Matrix4f)mat, (float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16);
    }

    private static String getMatrix4(float[] fs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fs.length; ++i) {
            String str = String.format("%.2f", Float.valueOf(fs[i]));
            if (i > 0) {
                if (i % 4 == 0) {
                    sb.append("\n");
                } else {
                    sb.append(", ");
                }
            }
            str = StrUtils.fillLeft((String)str, (int)5, (char)' ');
            sb.append(str);
        }
        return sb.toString();
    }

    public static void debugVboMemory(frc.b[] renderChunks) {
        if (!TimedEvent.isActive((String)"DbgVbos", (long)3000L)) {
            return;
        }
        int sum = 0;
        int countChunks = 0;
        int countVbos = 0;
        int countLayers = 0;
        for (int i = 0; i < renderChunks.length; ++i) {
            frc.b renderChunk = renderChunks[i];
            int sumPre = sum;
            for (fom rt : frc.BLOCK_RENDER_LAYERS) {
                els vb = renderChunk.a(rt);
                if (vb.getIndexCount() > 0) {
                    sum += vb.getIndexCount() * vb.d().b();
                    ++countVbos;
                }
                if (!renderChunk.d().isLayerUsed(rt)) continue;
                ++countLayers;
            }
            if (sum <= sumPre) continue;
            ++countChunks;
        }
        Config.dbg((String)("VRAM: " + sum / 0x100000 + " MB, vbos: " + countVbos + ", layers: " + countLayers + ", chunks: " + countChunks));
        Config.dbg((String)("VBOs: " + GpuMemory.getBufferAllocated() / 0x100000L + " MB"));
    }

    public static void debugTextures() {
        Config.dbg((String)" *** TEXTURES ***");
        fzf textureManager = eqv.O().Y();
        long sum = 0L;
        Collection locations = textureManager.getTextureLocations();
        ArrayList list = new ArrayList(locations);
        Collections.sort(list);
        for (aew loc : list) {
            fyp texture = textureManager.b(loc);
            long size = GpuMemory.getTextureSize((fyp)texture);
            if (Config.isShaders()) {
                size *= 3L;
            }
            Config.dbg((String)(loc + " = " + size));
            sum += size;
        }
        Config.dbg((String)("All: " + sum));
    }
}

