/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<ahg, ahg> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private clm[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final clm[] COLORS_INVALID = new clm[0];
    private static final ahg ANVIL_GUI_TEXTURE = new ahg("textures/gui/container/anvil.png");
    private static final ahg BEACON_GUI_TEXTURE = new ahg("textures/gui/container/beacon.png");
    private static final ahg BREWING_STAND_GUI_TEXTURE = new ahg("textures/gui/container/brewing_stand.png");
    private static final ahg CHEST_GUI_TEXTURE = new ahg("textures/gui/container/generic_54.png");
    private static final ahg CRAFTING_TABLE_GUI_TEXTURE = new ahg("textures/gui/container/crafting_table.png");
    private static final ahg HORSE_GUI_TEXTURE = new ahg("textures/gui/container/horse.png");
    private static final ahg DISPENSER_GUI_TEXTURE = new ahg("textures/gui/container/dispenser.png");
    private static final ahg ENCHANTMENT_TABLE_GUI_TEXTURE = new ahg("textures/gui/container/enchanting_table.png");
    private static final ahg FURNACE_GUI_TEXTURE = new ahg("textures/gui/container/furnace.png");
    private static final ahg HOPPER_GUI_TEXTURE = new ahg("textures/gui/container/hopper.png");
    private static final ahg INVENTORY_GUI_TEXTURE = new ahg("textures/gui/container/inventory.png");
    private static final ahg SHULKER_BOX_GUI_TEXTURE = new ahg("textures/gui/container/shulker_box.png");
    private static final ahg VILLAGER_GUI_TEXTURE = new ahg("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static clm[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        clm[] cols = new clm[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            clm col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static clm parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        clm[] colors = clm.values();
        for (int i = 0; i < colors.length; ++i) {
            clm enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static ahg parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new ahg(basePath + "/" + (String)tex);
    }

    private static Map<ahg, ahg> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<ahg, ahg> map = new HashMap<ahg, ahg>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            ahg locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            ahg locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            ahg locKey = new ahg(path);
            ahg locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static ahg getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[container.ordinal()]) {
            case 1: {
                return ANVIL_GUI_TEXTURE;
            }
            case 2: {
                return BEACON_GUI_TEXTURE;
            }
            case 3: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 4: {
                return CHEST_GUI_TEXTURE;
            }
            case 5: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 6: {
                return null;
            }
            case 7: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 8: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 9: {
                return FURNACE_GUI_TEXTURE;
            }
            case 10: {
                return HOPPER_GUI_TEXTURE;
            }
            case 11: {
                return HORSE_GUI_TEXTURE;
            }
            case 12: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 13: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 14: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, hx pos, cts blockAccess) {
        cuo biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((cuo)(biome = (cuo)blockAccess.t(pos).a()), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, hx pos, cts blockAccess, fdb screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((fdb)screen))) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 2: {
                return this.matchesBeacon(pos, (css)blockAccess);
            }
            case 4: {
                return this.matchesChest(pos, (css)blockAccess);
            }
            case 7: {
                return this.matchesDispenser(pos, (css)blockAccess);
            }
            case 13: {
                return this.matchesShulker(pos, (css)blockAccess);
            }
        }
        return true;
    }

    public static String getName(fdb screen) {
        vf itc = screen.o();
        if (itc == null) {
            return null;
        }
        return itc.getString();
    }

    private boolean matchesBeacon(hx pos, css blockAccess) {
        dgv te = blockAccess.c_(pos);
        if (!(te instanceof dgq)) {
            return false;
        }
        dgq teb = (dgq)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(hx pos, css blockAccess) {
        dgv te = blockAccess.c_(pos);
        if (te instanceof dhc) {
            dhc tec = (dhc)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof dhq) {
            dhq teec = (dhq)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(dhc tec, hx pos, css blockAccess) {
        djh blockState = blockAccess.a_(pos);
        djz chestType = blockState.b((dkk)cxt.d) ? (djz)blockState.c((dkk)cxt.d) : djz.a;
        boolean isLarge = chestType != djz.a;
        boolean isTrapped = tec instanceof din;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(dhq teec, hx pos, css blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(hx pos, css blockAccess) {
        EnumVariant var;
        dgv te = blockAccess.c_(pos);
        if (!(te instanceof dhn)) {
            return false;
        }
        dhn ted = (dhn)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(dhn ted) {
        if (ted instanceof dho) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(hx pos, css blockAccess) {
        clm col;
        dgv te = blockAccess.c_(pos);
        if (!(te instanceof did)) {
            return false;
        }
        did tesb = (did)te;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.w()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, blv entity, cts blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.dm(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cy())) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 14: {
                return this.matchesVillager(entity, (css)blockAccess);
            }
            case 11: {
                return this.matchesHorse(entity, (css)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(blv entity, css blockAccess) {
        int level;
        cew vd;
        cey vp;
        if (!(entity instanceof cev)) {
            return false;
        }
        cev entityVillager = (cev)entity;
        return this.professions == null || MatchProfession.matchesOne((cey)(vp = (vd = entityVillager.gp()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(blv entity, css blockAccess) {
        caa el;
        clm col;
        EnumVariant var;
        if (!(entity instanceof bzx)) {
            return false;
        }
        bzx ah = (bzx)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof caa) || Config.equalsOne((Object)(col = (el = (caa)ah).gr()), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(bzx entity) {
        if (entity instanceof bzz) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof bzy) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof cac) {
            return EnumVariant.MULE;
        }
        if (entity instanceof caa) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public ahg getTextureLocation(ahg loc) {
        ahg locNew = (ahg)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + this.container + ", textures: " + this.textureLocations;
    }
}

