/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.VirtualEntityRenderer;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<blz, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<dgx, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Map<blz, fym> originalEntityRenderMap;
    private static Map<dgx, fvh> originalTileEntityRenderMap;
    private static Map<ddr.a, flu> originalSkullModelMap;
    private static List<dgx> customTileEntityTypes;
    private static fjf customBookModel;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        fsu blockEntityRenderer = evi.O().aq().getBlockEntityRenderer();
        blockEntityRenderer.k = new fmc(ModelAdapter.bakeModelLayer((fmv)fmw.bF));
        blockEntityRenderer.j = new flo(ModelAdapter.bakeModelLayer((fmv)fmw.bg));
        gcv.customParrotModel = null;
        customBookModel = null;
        fvh.CACHED_TYPES.clear();
        if (evi.O().r != null) {
            Iterable entities = evi.O().r.e();
            for (blv entity : entities) {
                Map modelVariables = entity.an().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        ahg[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            ahg loc = locs[i];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((ahg)loc, (RendererCache)rendererCache, (int)0);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof fym) {
                fzz pr;
                fkx pm;
                gaz tr;
                fmc tm;
                entityRenderMap.put((blz)type.getLeft().get(), (fym)rc);
                rendererCache.put((blz)type.getLeft().get(), 0, (fym)rc);
                if (rc instanceof gaz && (tm = (fmc)Reflector.getFieldValue((Object)(tr = (gaz)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.k = tm;
                }
                if (rc instanceof fzz && (pm = (fkx)(pr = (fzz)rc).a()) != null) {
                    gcv.customParrotModel = pm;
                }
            } else if (rc instanceof fvh) {
                tileEntityRenderMap.put((dgx)type.getRight().get(), (fvh)rc);
                rendererCache.put((dgx)type.getRight().get(), 0, (fvh)rc);
                if (rc instanceof fvq) {
                    fvq etr = (fvq)rc;
                    fjf bm = (fjf)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((fjf)bm);
                }
                customTileEntityTypes.add((dgx)type.getRight().get());
            } else if (rc instanceof VirtualEntityRenderer) {
                VirtualEntityRenderer ver = (VirtualEntityRenderer)rc;
                if (ver.getModel() instanceof flo) {
                    flo sm;
                    blockEntityRenderer.j = sm = (flo)ver.getModel();
                }
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
                continue;
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (RandomEntityContext.Models)context);
            if (props == null) {
                props = CustomEntityModels.makeProperties((String)(name + "/" + name), (RandomEntityContext.Models)context);
            }
            if (props == null) continue;
            if (type != null && type.getLeft().isPresent()) {
                mapEntityProperties.put((blz)type.getLeft().get(), props);
            }
            if (type == null || !type.getRight().isPresent()) continue;
            mapBlockEntityProperties.put((dgx)type.getRight().get(), props);
        }
    }

    private static RandomEntityProperties makeProperties(String name, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        ahg locJem = new ahg("optifine/cem/" + name + ".jem");
        ahg locProps = new ahg("optifine/cem/" + name + ".properties");
        if (Config.hasResource((ahg)locProps) && (props = RandomEntityProperties.parse((ahg)locProps, (ahg)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((ahg)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((ahg)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(locJem.a(), locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    private static void setEnchantmentScreenBookModel(fjf bookModel) {
        customBookModel = bookModel;
    }

    private static Map<blz, fym> getEntityRenderMap() {
        fyl rm = evi.O().ao();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<dgx, fvh> getTileEntityRenderMap() {
        fvg blockEntityRenderDispatcher = evi.O().ap();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<ddr.a, flu> getSkullModelMap() {
        HashMap skullModelMap = fvw.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static ahg[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<ahg> resourceLocations = new ArrayList<ahg>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            ahg loc = new ahg(path);
            if (!Config.hasResource((ahg)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        ahg[] locs = resourceLocations.toArray(new ahg[resourceLocations.size()]);
        return locs;
    }

    public static IEntityRenderer parseEntityRender(ahg location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((ahg)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((ahg)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a(), (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(ahg loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        fkt model = ma.makeModel();
        clm[] colors = clm.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            fmx part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            clm col = colors[(i + offset) % colors.length];
            ahg locTexture = new ahg("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize(), rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        name = StrUtils.trimTrailing((String)name, (String)"0123456789");
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        fkt model;
        ahg textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fkt)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (fkt)model, (IEntityRenderer)r, (ahg)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, fkt model, IEntityRenderer er, ahg textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof fzo) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (fkt)model, (ahg)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, fkt model, ahg textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            fmx modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fkt model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fkt)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fkt model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        fmx parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                fmx[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    fmx mr = (fmx)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(djh blockStateIn) {
        for (int i = 0; i < customTileEntityTypes.size(); ++i) {
            dgx type = (dgx)customTileEntityTypes.get(i);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(fdb screen) {
        if (customBookModel != null && screen instanceof feu) {
            feu es = (feu)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static fym getEntityRenderer(blv entityIn, fym renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((blv)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.ai());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fym)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fym er = (fym)ier;
        return er;
    }

    public static fvh getBlockEntityRenderer(dgv entityIn, fvh renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((dgv)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.v());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof fvh)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        fvh ber = (fvh)ier;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        originalEntityRenderMap = null;
        originalTileEntityRenderMap = null;
        originalSkullModelMap = null;
        customTileEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

