/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.client.ClientBrandRetriever;
import net.optifine.Config;

public class VersionCheckThread
extends Thread {
    public VersionCheckThread() {
        super("VersionCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection conn = null;
        try {
            Config.dbg((String)"Checking for new version");
            URL url = new URL("http://optifine.net/version/1.21.8/HD_U.txt");
            conn = (HttpURLConnection)url.openConnection();
            boolean snooper = true;
            if (snooper) {
                conn.setRequestProperty("OF-MC-Version", "1.21.8");
                conn.setRequestProperty("OF-MC-Brand", ClientBrandRetriever.getClientModName());
                conn.setRequestProperty("OF-Edition", "HD_U");
                conn.setRequestProperty("OF-Release", "J6_pre16");
                conn.setRequestProperty("OF-Java-Version", System.getProperty("java.version"));
                conn.setRequestProperty("OF-CpuCount", "" + Config.getAvailableProcessors());
                conn.setRequestProperty("OF-OpenGL-Version", Config.openGlVersion);
                conn.setRequestProperty("OF-OpenGL-Vendor", Config.openGlVendor);
            }
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            try {
                InputStream in = conn.getInputStream();
                String verStr = Config.readInputStream((InputStream)in);
                in.close();
                String[] verLines = Config.tokenize((String)verStr, (String)"\n\r");
                if (verLines.length < 1) {
                    return;
                }
                String newVer = verLines[0].trim();
                Config.dbg((String)("Version found: " + newVer));
                if (Config.compareRelease((String)newVer, (String)"J6_pre16") <= 0) {
                    return;
                }
                Config.setNewRelease((String)newVer);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        catch (Exception e) {
            Config.dbg((String)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }
}

