/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.BlockAlias;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.ShaderPackNone;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlockAliases {
    private static BlockAlias[][] blockAliases = null;
    private static boolean hasAliasMetadata = false;
    private static PropertiesOrdered blockLayerPropertes = null;
    private static boolean updateOnResourcesReloaded;
    private static List<List<BlockAlias>> legacyAliases;

    public static int getAliasBlockId(eeb blockState) {
        int metadata;
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias((int)blockId, (int)(metadata = blockState.getMetadata()));
        if (alias != null) {
            return alias.getAliasBlockId();
        }
        return -1;
    }

    public static boolean hasAliasMetadata() {
        return hasAliasMetadata;
    }

    public static int getAliasMetadata(eeb blockState) {
        int metadata;
        if (!hasAliasMetadata) {
            return 0;
        }
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias((int)blockId, (int)(metadata = blockState.getMetadata()));
        if (alias != null) {
            return alias.getAliasMetadata();
        }
        return 0;
    }

    public static BlockAlias getBlockAlias(int blockId, int metadata) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        if (aliases == null) {
            return null;
        }
        for (int i2 = 0; i2 < aliases.length; ++i2) {
            BlockAlias ba = aliases[i2];
            if (!ba.matches(blockId, metadata)) continue;
            return ba;
        }
        return null;
    }

    public static BlockAlias[] getBlockAliases(int blockId) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        return aliases;
    }

    public static void resourcesReloaded() {
        if (!updateOnResourcesReloaded) {
            return;
        }
        updateOnResourcesReloaded = false;
        BlockAliases.update((IShaderPack)Shaders.getShaderPack());
    }

    public static void update(IShaderPack shaderPack) {
        BlockAliases.reset();
        if (shaderPack == null) {
            return;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return;
        }
        if (Reflector.ModList.exists() && fue.R().ad() == null) {
            Config.dbg((String)"[Shaders] Delayed loading of block mappings after resources are loaded");
            updateOnResourcesReloaded = true;
            return;
        }
        List listBlockAliases = new ArrayList();
        String path = "/shaders/block.properties";
        InputStream in = shaderPack.getResourceAsStream(path);
        if (in != null) {
            BlockAliases.loadBlockAliases((InputStream)in, (String)path, listBlockAliases);
        }
        BlockAliases.loadModBlockAliases(listBlockAliases);
        if (listBlockAliases.size() <= 0) {
            listBlockAliases = BlockAliases.getLegacyAliases();
            hasAliasMetadata = true;
        }
        blockAliases = BlockAliases.toBlockAliasArrays(listBlockAliases);
    }

    private static void loadModBlockAliases(List<List<BlockAlias>> listBlockAliases) {
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                ame loc = new ame(modId, "shaders/block.properties");
                InputStream in = Config.getResourceStream((ame)loc);
                BlockAliases.loadBlockAliases((InputStream)in, (String)loc.toString(), listBlockAliases);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadBlockAliases(InputStream in, String path, List<List<BlockAlias>> listBlockAliases) {
        if (in == null) {
            return;
        }
        try {
            in = MacroProcessor.process((InputStream)in, (String)path, (boolean)true);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg((String)("[Shaders] Parsing block mappings: " + path));
            ConnectedParser cp = new ConnectedParser("Shaders");
            Set<Object> keys = props.keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                if (string.startsWith("layer.")) {
                    if (blockLayerPropertes == null) {
                        blockLayerPropertes = new PropertiesOrdered();
                    }
                    blockLayerPropertes.put((Object)string, (Object)val);
                    continue;
                }
                String prefix = "block.";
                if (!string.startsWith(prefix)) {
                    Config.warn((String)("[Shaders] Invalid block ID: " + string));
                    continue;
                }
                String blockIdStr = StrUtils.removePrefix((String)string, (String)prefix);
                int blockId = Config.parseInt((String)blockIdStr, (int)-1);
                if (blockId < 0) {
                    Config.warn((String)("[Shaders] Invalid block ID: " + string));
                    continue;
                }
                MatchBlock[] matchBlocks = cp.parseMatchBlocks(val);
                if (matchBlocks == null || matchBlocks.length < 1) {
                    Config.warn((String)("[Shaders] Invalid block ID mapping: " + string + "=" + val));
                    continue;
                }
                BlockAlias ba = new BlockAlias(blockId, matchBlocks);
                BlockAliases.addToList(listBlockAliases, (BlockAlias)ba);
            }
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error reading: " + path));
        }
    }

    private static void addToList(List<List<BlockAlias>> blocksAliases, BlockAlias ba) {
        int[] blockIds = ba.getMatchBlockIds();
        for (int i2 = 0; i2 < blockIds.length; ++i2) {
            int blockId = blockIds[i2];
            while (blockId >= blocksAliases.size()) {
                blocksAliases.add(null);
            }
            List<BlockAlias> blockAliases = blocksAliases.get(blockId);
            if (blockAliases == null) {
                blockAliases = new ArrayList<BlockAlias>();
                blocksAliases.set(blockId, blockAliases);
            }
            BlockAlias baBlock = new BlockAlias(ba.getAliasBlockId(), ba.getMatchBlocks(blockId));
            blockAliases.add(baBlock);
        }
    }

    private static BlockAlias[][] toBlockAliasArrays(List<List<BlockAlias>> listBlocksAliases) {
        BlockAlias[][] bas = new BlockAlias[listBlocksAliases.size()][];
        for (int i2 = 0; i2 < bas.length; ++i2) {
            List<BlockAlias> listBlockAliases = listBlocksAliases.get(i2);
            if (listBlockAliases == null) continue;
            bas[i2] = listBlockAliases.toArray(new BlockAlias[listBlockAliases.size()]);
        }
        return bas;
    }

    private static List<List<BlockAlias>> getLegacyAliases() {
        if (legacyAliases == null) {
            legacyAliases = BlockAliases.makeLegacyAliases();
        }
        return legacyAliases;
    }

    private static List<List<BlockAlias>> makeLegacyAliases() {
        try {
            String path = "flattening_ids.txt";
            Config.dbg((String)("Using legacy block aliases: " + path));
            ArrayList<List<BlockAlias>> listAliases = new ArrayList<List<BlockAlias>>();
            ArrayList<String> listLines = new ArrayList<String>();
            int countAliases = 0;
            InputStream in = Config.getOptiFineResourceStream((String)("/" + path));
            if (in == null) {
                return listAliases;
            }
            String[] lines = Config.readLines((InputStream)in);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                int lineNum = i2 + 1;
                String line = lines[i2];
                if (line.trim().length() <= 0) continue;
                listLines.add(line);
                if (line.startsWith("#")) continue;
                if (line.startsWith("alias")) {
                    String[] parts = Config.tokenize((String)line, (String)" ");
                    String blockAliasStr = parts[1];
                    String blockStr = parts[2];
                    String prefix = "{Name:'" + blockStr + "'";
                    List blockLines = listLines.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
                    if (blockLines.size() <= 0) {
                        Config.warn((String)("Block not processed: " + line));
                        continue;
                    }
                    for (String lineBlock : blockLines) {
                        String prefixNew = "{Name:'" + blockAliasStr + "'";
                        String lineNew = lineBlock.replace(prefix, prefixNew);
                        listLines.add(lineNew);
                        BlockAliases.addLegacyAlias((String)lineNew, (int)lineNum, listAliases);
                        ++countAliases;
                    }
                    continue;
                }
                BlockAliases.addLegacyAlias((String)line, (int)lineNum, listAliases);
                ++countAliases;
            }
            Config.dbg((String)("Legacy block aliases: " + countAliases));
            return listAliases;
        }
        catch (IOException e2) {
            Config.warn((String)("Error loading legacy block aliases: " + e2.getClass().getName() + ": " + e2.getMessage()));
            return new ArrayList<List<BlockAlias>>();
        }
    }

    private static void addLegacyAlias(String line, int lineNum, List<List<BlockAlias>> listAliases) {
        String[] parts = Config.tokenize((String)line, (String)" ");
        if (parts.length != 4) {
            Config.warn((String)("Invalid flattening line: " + line));
            return;
        }
        String partNew = parts[0];
        String partOld = parts[1];
        int blockIdOld = Config.parseInt((String)parts[2], (int)Integer.MIN_VALUE);
        int metadataOld = Config.parseInt((String)parts[3], (int)Integer.MIN_VALUE);
        if (blockIdOld < 0 || metadataOld < 0) {
            Config.warn((String)("Invalid blockID or metadata (" + lineNum + "): " + blockIdOld + ":" + metadataOld));
            return;
        }
        try {
            JsonParser jp = new JsonParser();
            JsonObject jo = jp.parse(partNew).getAsJsonObject();
            String name = jo.get("Name").getAsString();
            ame loc = new ame(name);
            dpz block = BlockUtils.getBlock((ame)loc);
            if (block == null) {
                Config.warn((String)("Invalid block name (" + lineNum + "): " + name));
                return;
            }
            eeb blockState = block.m();
            Collection stateProperties = blockState.F();
            LinkedHashMap<efe, Comparable> mapProperties = new LinkedHashMap<efe, Comparable>();
            JsonObject properties = (JsonObject)jo.get("Properties");
            if (properties != null) {
                Set entries = properties.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    efe prop = ConnectedProperties.getProperty((String)key, (Collection)stateProperties);
                    if (prop == null) {
                        Config.warn((String)("Invalid property (" + lineNum + "): " + key));
                        continue;
                    }
                    Comparable propVal = ConnectedParser.parsePropertyValue((efe)prop, (String)value);
                    if (propVal == null) {
                        Config.warn((String)("Invalid property value (" + lineNum + "): " + value));
                        continue;
                    }
                    mapProperties.put(prop, propVal);
                }
            }
            int blockId = blockState.getBlockId();
            while (listAliases.size() <= blockId) {
                listAliases.add(null);
            }
            List<BlockAlias> las = listAliases.get(blockId);
            if (las == null) {
                las = new ArrayList<BlockAlias>(BlockUtils.getMetadataCount((dpz)block));
                listAliases.set(blockId, las);
            }
            MatchBlock mb = BlockAliases.getMatchBlock((dpz)blockState.b(), (int)blockState.getBlockId(), mapProperties);
            BlockAliases.addBlockAlias(las, (int)blockIdOld, (int)metadataOld, (MatchBlock)mb);
        }
        catch (Exception e2) {
            Config.warn((String)("Error parsing: " + line));
        }
    }

    private static void addBlockAlias(List<BlockAlias> listBlockAliases, int aliasBlockId, int aliasMetadata, MatchBlock matchBlock) {
        for (BlockAlias ba : listBlockAliases) {
            if (ba.getAliasBlockId() != aliasBlockId || ba.getAliasMetadata() != aliasMetadata) continue;
            MatchBlock[] mbs = ba.getMatchBlocks();
            for (int i2 = 0; i2 < mbs.length; ++i2) {
                MatchBlock mb = mbs[i2];
                if (mb.getBlockId() != matchBlock.getBlockId()) continue;
                mb.addMetadatas(matchBlock.getMetadatas());
                return;
            }
        }
        BlockAlias ba = new BlockAlias(aliasBlockId, aliasMetadata, new MatchBlock[]{matchBlock});
        listBlockAliases.add(ba);
    }

    private static MatchBlock getMatchBlock(dpz block, int blockId, Map<efe, Comparable> mapProperties) {
        ArrayList<Object> matchingStates = new ArrayList<Object>();
        Set<efe> props = mapProperties.keySet();
        List states = BlockUtils.getBlockStates((dpz)block);
        for (Object bs : states) {
            boolean bl = true;
            for (efe prop : props) {
                Comparable val2;
                if (!bs.b(prop)) {
                    bl = false;
                    break;
                }
                Comparable val1 = mapProperties.get(prop);
                if (val1.equals(val2 = bs.c(prop))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            matchingStates.add(bs);
        }
        LinkedHashSet<Integer> setMetadatas = new LinkedHashSet<Integer>();
        for (eeb eeb2 : matchingStates) {
            setMetadatas.add(eeb2.getMetadata());
        }
        Integer[] metadatas = setMetadatas.toArray(new Integer[setMetadatas.size()]);
        int[] nArray = Config.toPrimitive((Integer[])metadatas);
        MatchBlock mb = new MatchBlock(blockId, nArray);
        return mb;
    }

    private static void checkLegacyAliases() {
        Set locs = mm.e.i();
        for (ame loc : locs) {
            dpz block = (dpz)mm.e.a(loc);
            int blockId = block.m().getBlockId();
            BlockAlias[] bas = BlockAliases.getBlockAliases((int)blockId);
            if (bas == null) {
                Config.warn((String)("Block has no alias: " + String.valueOf(block)));
                continue;
            }
            List states = BlockUtils.getBlockStates((dpz)block);
            for (eeb state : states) {
                int metadata = state.getMetadata();
                BlockAlias ba = BlockAliases.getBlockAlias((int)blockId, (int)metadata);
                if (ba != null) continue;
                Config.warn((String)("State has no alias: " + String.valueOf(state)));
            }
        }
    }

    public static PropertiesOrdered getBlockLayerPropertes() {
        return blockLayerPropertes;
    }

    public static void reset() {
        blockAliases = null;
        hasAliasMetadata = false;
        blockLayerPropertes = null;
    }

    public static int getRenderType(eeb blockState) {
        if (hasAliasMetadata) {
            dpz block = blockState.b();
            if (block instanceof duw) {
                return 1;
            }
            dwn brt = blockState.o();
            if (brt == dwn.b) {
                return brt.ordinal() + 1;
            }
            return brt.ordinal();
        }
        return blockState.o().ordinal();
    }
}

