/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.optifine.Config;
import net.optifine.CrashReporter;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class CrashReporter {
    public static void onCrashReport(o crashReport, ac category) {
        try {
            Throwable cause = crashReport.b();
            if (cause == null) {
                return;
            }
            if (cause.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            if (cause.getClass() == Throwable.class) {
                return;
            }
            if (cause.getClass() == Exception.class && Config.equals((Object)cause.getMessage(), (Object)"dummy")) {
                return;
            }
            CrashReporter.extendCrashReport((ac)category);
            if (!Config.isTelemetryOn()) {
                return;
            }
            String url = "http://optifine.net/crashReport";
            String reportStr = CrashReporter.makeReport((o)crashReport);
            byte[] content = reportStr.getBytes("ASCII");
            1 listener = new /* Unavailable Anonymous Inner Class!! */;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("OF-Version", Config.getVersion());
            headers.put("OF-Summary", CrashReporter.makeSummary((o)crashReport));
            FileUploadThread fut = new FileUploadThread(url, headers, content, (IFileUploadListener)listener);
            fut.setPriority(10);
            fut.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Config.dbg((String)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    private static String makeReport(o crashReport) {
        StringBuffer sb = new StringBuffer();
        sb.append("OptiFineVersion: " + Config.getVersion() + "\n");
        sb.append("Summary: " + CrashReporter.makeSummary((o)crashReport) + "\n");
        sb.append("\n");
        sb.append(crashReport.a(y.a));
        sb.append("\n");
        return sb.toString();
    }

    private static String makeSummary(o crashReport) {
        Throwable t = crashReport.b();
        if (t == null) {
            return "Unknown";
        }
        StackTraceElement[] traces = t.getStackTrace();
        String firstTrace = "unknown";
        if (traces.length > 0) {
            firstTrace = traces[0].toString().trim();
        }
        String sum = t.getClass().getName() + ": " + t.getMessage() + " (" + crashReport.a() + ") [" + firstTrace + "]";
        return sum;
    }

    public static void extendCrashReport(ac cat) {
        cat.a("OptiFine Version", Config.getVersion());
        cat.a("OptiFine Build", Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat.a("Render Distance Chunks", "" + Config.getChunkViewDistance());
            cat.a("Mipmaps", "" + Config.getMipmapLevels());
            cat.a("Anisotropic Filtering", "" + Config.getAnisotropicFilterLevel());
            cat.a("Antialiasing", "" + Config.getAntialiasingLevel());
            cat.a("Multitexture", "" + Config.isMultiTexture());
        }
        cat.a("Shaders", Shaders.getShaderPackName());
        cat.a("OpenGlVersion", Config.openGlVersion);
        cat.a("OpenGlRenderer", Config.openGlRenderer);
        cat.a("OpenGlVendor", Config.openGlVendor);
        cat.a("CpuCount", "" + Config.getAvailableProcessors());
    }
}

