/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<akr, akr> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private cti[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final cti[] COLORS_INVALID = new cti[0];
    private static final akr ANVIL_GUI_TEXTURE = new akr("textures/gui/container/anvil.png");
    private static final akr BEACON_GUI_TEXTURE = new akr("textures/gui/container/beacon.png");
    private static final akr BREWING_STAND_GUI_TEXTURE = new akr("textures/gui/container/brewing_stand.png");
    private static final akr CHEST_GUI_TEXTURE = new akr("textures/gui/container/generic_54.png");
    private static final akr CRAFTING_TABLE_GUI_TEXTURE = new akr("textures/gui/container/crafting_table.png");
    private static final akr HORSE_GUI_TEXTURE = new akr("textures/gui/container/horse.png");
    private static final akr DISPENSER_GUI_TEXTURE = new akr("textures/gui/container/dispenser.png");
    private static final akr ENCHANTMENT_TABLE_GUI_TEXTURE = new akr("textures/gui/container/enchanting_table.png");
    private static final akr FURNACE_GUI_TEXTURE = new akr("textures/gui/container/furnace.png");
    private static final akr HOPPER_GUI_TEXTURE = new akr("textures/gui/container/hopper.png");
    private static final akr INVENTORY_GUI_TEXTURE = new akr("textures/gui/container/inventory.png");
    private static final akr SHULKER_BOX_GUI_TEXTURE = new akr("textures/gui/container/shulker_box.png");
    private static final akr VILLAGER_GUI_TEXTURE = new akr("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static cti[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        cti[] cols = new cti[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            cti col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static cti parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        cti[] colors = cti.values();
        for (int i = 0; i < colors.length; ++i) {
            cti enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static akr parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new akr(basePath + "/" + (String)tex);
    }

    private static Map<akr, akr> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<akr, akr> map = new HashMap<akr, akr>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            akr locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            akr locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            akr locKey = new akr(path);
            akr locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static akr getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container.ordinal()) {
            case 0: {
                return ANVIL_GUI_TEXTURE;
            }
            case 1: {
                return BEACON_GUI_TEXTURE;
            }
            case 2: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 3: {
                return CHEST_GUI_TEXTURE;
            }
            case 4: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 12: {
                return null;
            }
            case 5: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 6: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 7: {
                return FURNACE_GUI_TEXTURE;
            }
            case 8: {
                return HOPPER_GUI_TEXTURE;
            }
            case 9: {
                return HORSE_GUI_TEXTURE;
            }
            case 13: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 11: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 10: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, jd pos, dcz blockAccess) {
        ddw biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((ddw)(biome = (ddw)blockAccess.t(pos).a()), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, jd pos, dcz blockAccess, fod screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((fod)screen))) {
            return false;
        }
        switch (ec.ordinal()) {
            case 1: {
                return this.matchesBeacon(pos, (dbz)blockAccess);
            }
            case 3: {
                return this.matchesChest(pos, (dbz)blockAccess);
            }
            case 5: {
                return this.matchesDispenser(pos, (dbz)blockAccess);
            }
            case 11: {
                return this.matchesShulker(pos, (dbz)blockAccess);
            }
        }
        return true;
    }

    public static String getName(fod screen) {
        wz itc = screen.n();
        if (itc == null) {
            return null;
        }
        return itc.getString();
    }

    private boolean matchesBeacon(jd pos, dbz blockAccess) {
        dqh te = blockAccess.c_(pos);
        if (!(te instanceof dqc)) {
            return false;
        }
        dqc teb = (dqc)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(jd pos, dbz blockAccess) {
        dqh te = blockAccess.c_(pos);
        if (te instanceof dqo) {
            dqo tec = (dqo)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof drd) {
            drd teec = (drd)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(dqo tec, jd pos, dbz blockAccess) {
        dtc blockState = blockAccess.a_(pos);
        dtu chestType = blockState.b((duf)dhb.d) ? (dtu)blockState.c((duf)dhb.d) : dtu.a;
        boolean isLarge = chestType != dtu.a;
        boolean isTrapped = tec instanceof dsb;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(drd teec, jd pos, dbz blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(jd pos, dbz blockAccess) {
        EnumVariant var;
        dqh te = blockAccess.c_(pos);
        if (!(te instanceof dra)) {
            return false;
        }
        dra ted = (dra)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(dra ted) {
        if (ted instanceof drb) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(jd pos, dbz blockAccess) {
        cti col;
        dqh te = blockAccess.c_(pos);
        if (!(te instanceof drr)) {
            return false;
        }
        drr tesb = (drr)te;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.u()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, bsr entity, dcz blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.do(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cB())) {
            return false;
        }
        switch (ec.ordinal()) {
            case 10: {
                return this.matchesVillager(entity, (dbz)blockAccess);
            }
            case 9: {
                return this.matchesHorse(entity, (dbz)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(bsr entity, dbz blockAccess) {
        int level;
        cml vd;
        cmn vp;
        if (!(entity instanceof cmk)) {
            return false;
        }
        cmk entityVillager = (cmk)entity;
        return this.professions == null || MatchProfession.matchesOne((cmn)(vp = (vd = entityVillager.gv()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(bsr entity, dbz blockAccess) {
        chl el;
        cti col;
        EnumVariant var;
        if (!(entity instanceof chi)) {
            return false;
        }
        chi ah = (chi)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof chl) || Config.equalsOne((Object)(col = (el = (chl)ah).gw()), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(chi entity) {
        if (entity instanceof chk) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof chj) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof chn) {
            return EnumVariant.MULE;
        }
        if (entity instanceof chl) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public akr getTextureLocation(akr loc) {
        akr locNew = (akr)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + String.valueOf(this.container) + ", textures: " + String.valueOf(this.textureLocations);
    }
}

