/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.List;
import net.optifine.model.Attachment;
import net.optifine.model.AttachmentPath;
import net.optifine.model.AttachmentType;

public class AttachmentPaths {
    private List<List<AttachmentPath>> pathsByType = new ArrayList();

    public void addPath(AttachmentPath ap) {
        AttachmentType type = ap.getAttachment().getType();
        while (this.pathsByType.size() <= type.ordinal()) {
            this.pathsByType.add(null);
        }
        ArrayList<AttachmentPath> paths = (ArrayList<AttachmentPath>)this.pathsByType.get(type.ordinal());
        if (paths == null) {
            paths = new ArrayList<AttachmentPath>();
            this.pathsByType.set(type.ordinal(), paths);
        }
        paths.add(ap);
    }

    public void addPaths(List<fyk> parents, Attachment[] attachments) {
        fyk[] parentArr = parents.toArray(new fyk[parents.size()]);
        for (int i = 0; i < attachments.length; ++i) {
            Attachment at = attachments[i];
            AttachmentPath path = new AttachmentPath(at, parentArr);
            this.addPath(path);
        }
    }

    public boolean isEmpty() {
        return this.pathsByType.isEmpty();
    }

    public AttachmentPath getVisiblePath(AttachmentType typeIn) {
        if (this.pathsByType.size() <= typeIn.ordinal()) {
            return null;
        }
        List paths = (List)this.pathsByType.get(typeIn.ordinal());
        for (AttachmentPath path : paths) {
            if (!path.isVisible()) continue;
            return path;
        }
        return null;
    }

    public String toString() {
        int count = 0;
        for (List paths : this.pathsByType) {
            if (paths == null) continue;
            ++count;
        }
        return "types: " + count;
    }
}

