/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.player;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.model.Attachment;
import net.optifine.model.AttachmentType;
import net.optifine.player.ModelPlayerItem;
import net.optifine.player.PlayerItemModel;
import net.optifine.player.PlayerItemRenderer;
import net.optifine.util.Json;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlayerItemParser {
    private static JsonParser jsonParser = new JsonParser();
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_TEXTURE_SIZE = "textureSize";
    public static final String ITEM_USE_PLAYER_TEXTURE = "usePlayerTexture";
    public static final String ITEM_MODELS = "models";
    public static final String MODEL_ID = "id";
    public static final String MODEL_BASE_ID = "baseId";
    public static final String MODEL_TYPE = "type";
    public static final String MODEL_TEXTURE = "texture";
    public static final String MODEL_TEXTURE_SIZE = "textureSize";
    public static final String MODEL_ATTACH_TO = "attachTo";
    public static final String MODEL_INVERT_AXIS = "invertAxis";
    public static final String MODEL_MIRROR_TEXTURE = "mirrorTexture";
    public static final String MODEL_TRANSLATE = "translate";
    public static final String MODEL_ROTATE = "rotate";
    public static final String MODEL_SCALE = "scale";
    public static final String MODEL_ATTACHMENTS = "attachments";
    public static final String MODEL_BOXES = "boxes";
    public static final String MODEL_SPRITES = "sprites";
    public static final String MODEL_SUBMODEL = "submodel";
    public static final String MODEL_SUBMODELS = "submodels";
    public static final String BOX_TEXTURE_OFFSET = "textureOffset";
    public static final String BOX_COORDINATES = "coordinates";
    public static final String BOX_SIZE_ADD = "sizeAdd";
    public static final String BOX_UV_DOWN = "uvDown";
    public static final String BOX_UV_UP = "uvUp";
    public static final String BOX_UV_NORTH = "uvNorth";
    public static final String BOX_UV_SOUTH = "uvSouth";
    public static final String BOX_UV_WEST = "uvWest";
    public static final String BOX_UV_EAST = "uvEast";
    public static final String BOX_UV_FRONT = "uvFront";
    public static final String BOX_UV_BACK = "uvBack";
    public static final String BOX_UV_LEFT = "uvLeft";
    public static final String BOX_UV_RIGHT = "uvRight";
    public static final String ITEM_TYPE_MODEL = "PlayerItem";
    public static final String MODEL_TYPE_BOX = "ModelBox";
    private static AtomicInteger counter = new AtomicInteger();

    private PlayerItemParser() {
    }

    public static PlayerItemModel parseItemModel(JsonObject obj) {
        String type = Json.getString((JsonObject)obj, (String)"type");
        if (!Config.equals((Object)type, (Object)"PlayerItem")) {
            throw new JsonParseException("Unknown model type: " + type);
        }
        int[] textureSize = Json.parseIntArray((JsonElement)obj.get("textureSize"), (int)2);
        PlayerItemParser.checkNull((Object)textureSize, (String)"Missing texture size");
        Dimension textureDim = new Dimension(textureSize[0], textureSize[1]);
        boolean usePlayerTexture = Json.getBoolean((JsonObject)obj, (String)"usePlayerTexture", (boolean)false);
        JsonArray models = (JsonArray)obj.get("models");
        PlayerItemParser.checkNull((Object)models, (String)"Missing elements");
        HashMap<String, JsonObject> mapModelJsons = new HashMap<String, JsonObject>();
        ArrayList<PlayerItemRenderer> listModels = new ArrayList<PlayerItemRenderer>();
        ArrayList listAttachTos = new ArrayList();
        for (int i = 0; i < models.size(); ++i) {
            PlayerItemRenderer mr;
            String id;
            JsonObject elem = (JsonObject)models.get(i);
            String baseId = Json.getString((JsonObject)elem, (String)"baseId");
            if (baseId != null) {
                JsonObject baseObj = (JsonObject)mapModelJsons.get(baseId);
                if (baseObj == null) {
                    Config.warn((String)("BaseID not found: " + baseId));
                    continue;
                }
                Set setEntries = baseObj.entrySet();
                for (Map.Entry entry : setEntries) {
                    if (elem.has((String)entry.getKey())) continue;
                    elem.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
            if ((id = Json.getString((JsonObject)elem, (String)"id")) != null) {
                if (!mapModelJsons.containsKey(id)) {
                    mapModelJsons.put(id, elem);
                } else {
                    Config.warn((String)("Duplicate model ID: " + id));
                }
            }
            if ((mr = PlayerItemParser.parseItemRenderer((JsonObject)elem, (Dimension)textureDim)) == null) continue;
            listModels.add(mr);
        }
        PlayerItemRenderer[] modelRenderers = listModels.toArray(new PlayerItemRenderer[listModels.size()]);
        return new PlayerItemModel(textureDim, usePlayerTexture, modelRenderers);
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    private static akr makeResourceLocation(String texture) {
        int pos = texture.indexOf(58);
        if (pos < 0) {
            return new akr(texture);
        }
        String domain = texture.substring(0, pos);
        String path = texture.substring(pos + 1);
        return new akr(domain, path);
    }

    private static int parseAttachModel(String attachModelStr) {
        String str = attachModelStr;
        if (str == null) {
            return 0;
        }
        if (str.equals("body")) {
            return 0;
        }
        if (str.equals("head")) {
            return 1;
        }
        if (str.equals("leftArm")) {
            return 2;
        }
        if (str.equals("rightArm")) {
            return 3;
        }
        if (str.equals("leftLeg")) {
            return 4;
        }
        if (str.equals("rightLeg")) {
            return 5;
        }
        if (str.equals("cape")) {
            return 6;
        }
        Config.warn((String)("Unknown attachModel: " + str));
        return 0;
    }

    public static PlayerItemRenderer parseItemRenderer(JsonObject elem, Dimension textureDim) {
        String type = Json.getString((JsonObject)elem, (String)"type");
        if (!Config.equals((Object)type, (Object)"ModelBox")) {
            Config.warn((String)("Unknown model type: " + type));
            return null;
        }
        String attachToStr = Json.getString((JsonObject)elem, (String)"attachTo");
        int attachTo = PlayerItemParser.parseAttachModel((String)attachToStr);
        ModelPlayerItem modelBase = new ModelPlayerItem(gfh::e);
        modelBase.textureWidth = textureDim.width;
        modelBase.textureHeight = textureDim.height;
        fyk mr = PlayerItemParser.parseModelRenderer((JsonObject)elem, (fwg)modelBase, null, null);
        PlayerItemRenderer pir = new PlayerItemRenderer(attachTo, mr);
        return pir;
    }

    public static fyk parseModelRenderer(JsonObject elem, fwg modelBase, int[] parentTextureSize, String basePath) {
        JsonArray submodels;
        JsonObject submodel;
        JsonArray sprites;
        float sizeAdd;
        float[] coordinates;
        int[] textureSize;
        float scale;
        ArrayList cubeList = new ArrayList();
        HashMap childModels = new HashMap();
        fyk mr = new fyk(cubeList, childModels);
        mr.setCustom(true);
        mr.setTextureSize(modelBase.textureWidth, modelBase.textureHeight);
        String id = Json.getString((JsonObject)elem, (String)"id");
        mr.setId(id);
        mr.h = scale = Json.getFloat((JsonObject)elem, (String)"scale", (float)1.0f);
        mr.i = scale;
        mr.j = scale;
        String texture = Json.getString((JsonObject)elem, (String)"texture");
        if (texture != null) {
            mr.setTextureLocation(CustomEntityModelParser.getResourceLocation((String)basePath, (String)texture, (String)".png"));
        }
        if ((textureSize = Json.parseIntArray((JsonElement)elem.get("textureSize"), (int)2)) == null) {
            textureSize = parentTextureSize;
        }
        if (textureSize != null) {
            mr.setTextureSize(textureSize[0], textureSize[1]);
        }
        String invertAxis = Json.getString((JsonObject)elem, (String)"invertAxis", (String)"").toLowerCase();
        boolean invertX = invertAxis.contains("x");
        boolean invertY = invertAxis.contains("y");
        boolean invertZ = invertAxis.contains("z");
        float[] translate = Json.parseFloatArray((JsonElement)elem.get("translate"), (int)3, (float[])new float[3]);
        if (invertX) {
            translate[0] = -translate[0];
        }
        if (invertY) {
            translate[1] = -translate[1];
        }
        if (invertZ) {
            translate[2] = -translate[2];
        }
        float[] rotateAngles = Json.parseFloatArray((JsonElement)elem.get("rotate"), (int)3, (float[])new float[3]);
        for (int i = 0; i < rotateAngles.length; ++i) {
            rotateAngles[i] = rotateAngles[i] / 180.0f * (float)Math.PI;
        }
        if (invertX) {
            rotateAngles[0] = -rotateAngles[0];
        }
        if (invertY) {
            rotateAngles[1] = -rotateAngles[1];
        }
        if (invertZ) {
            rotateAngles[2] = -rotateAngles[2];
        }
        mr.a(translate[0], translate[1], translate[2]);
        mr.e = rotateAngles[0];
        mr.f = rotateAngles[1];
        mr.g = rotateAngles[2];
        String mirrorTexture = Json.getString((JsonObject)elem, (String)"mirrorTexture", (String)"").toLowerCase();
        boolean invertU = mirrorTexture.contains("u");
        boolean invertV = mirrorTexture.contains("v");
        if (invertU) {
            mr.mirror = true;
        }
        if (invertV) {
            mr.mirrorV = true;
        }
        Attachment[] attachments = PlayerItemParser.parseAttachments((JsonObject)elem.getAsJsonObject("attachments"));
        mr.setAttachments(attachments);
        JsonArray boxes = elem.getAsJsonArray("boxes");
        if (boxes != null) {
            for (int i = 0; i < boxes.size(); ++i) {
                JsonObject box = boxes.get(i).getAsJsonObject();
                float[] textureOffset = Json.parseFloatArray((JsonElement)box.get("textureOffset"), (int)2);
                float[][] faceUvs = PlayerItemParser.parseFaceUvs((JsonObject)box);
                if (textureOffset == null && faceUvs == null) {
                    throw new JsonParseException("Texture offset not specified");
                }
                coordinates = Json.parseFloatArray((JsonElement)box.get("coordinates"), (int)6);
                if (coordinates == null) {
                    throw new JsonParseException("Coordinates not specified");
                }
                if (invertX) {
                    coordinates[0] = -coordinates[0] - coordinates[3];
                }
                if (invertY) {
                    coordinates[1] = -coordinates[1] - coordinates[4];
                }
                if (invertZ) {
                    coordinates[2] = -coordinates[2] - coordinates[5];
                }
                sizeAdd = Json.getFloat((JsonObject)box, (String)"sizeAdd", (float)0.0f);
                if (faceUvs != null) {
                    mr.addBox(faceUvs, coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5], sizeAdd);
                    continue;
                }
                mr.setTextureOffset(textureOffset[0], textureOffset[1]);
                mr.addBox(coordinates[0], coordinates[1], coordinates[2], (float)((int)coordinates[3]), (float)((int)coordinates[4]), (float)((int)coordinates[5]), sizeAdd);
            }
        }
        if ((sprites = elem.getAsJsonArray("sprites")) != null) {
            for (int i = 0; i < sprites.size(); ++i) {
                JsonObject sprite = sprites.get(i).getAsJsonObject();
                int[] textureOffset = Json.parseIntArray((JsonElement)sprite.get("textureOffset"), (int)2);
                if (textureOffset == null) {
                    throw new JsonParseException("Texture offset not specified");
                }
                coordinates = Json.parseFloatArray((JsonElement)sprite.get("coordinates"), (int)6);
                if (coordinates == null) {
                    throw new JsonParseException("Coordinates not specified");
                }
                if (invertX) {
                    coordinates[0] = -coordinates[0] - coordinates[3];
                }
                if (invertY) {
                    coordinates[1] = -coordinates[1] - coordinates[4];
                }
                if (invertZ) {
                    coordinates[2] = -coordinates[2] - coordinates[5];
                }
                sizeAdd = Json.getFloat((JsonObject)sprite, (String)"sizeAdd", (float)0.0f);
                mr.setTextureOffset((float)textureOffset[0], (float)textureOffset[1]);
                mr.addSprite(coordinates[0], coordinates[1], coordinates[2], (int)coordinates[3], (int)coordinates[4], (int)coordinates[5], sizeAdd);
            }
        }
        if ((submodel = (JsonObject)elem.get("submodel")) != null) {
            fyk subMr = PlayerItemParser.parseModelRenderer((JsonObject)submodel, (fwg)modelBase, (int[])textureSize, (String)basePath);
            mr.addChildModel(PlayerItemParser.getNextModelId(), subMr);
        }
        if ((submodels = (JsonArray)elem.get("submodels")) != null) {
            for (int i = 0; i < submodels.size(); ++i) {
                fyk subMrId;
                JsonObject sm = (JsonObject)submodels.get(i);
                fyk subMr = PlayerItemParser.parseModelRenderer((JsonObject)sm, (fwg)modelBase, (int[])textureSize, (String)basePath);
                if (subMr.getId() != null && (subMrId = mr.getChild(subMr.getId())) != null) {
                    Config.warn((String)("Duplicate model ID: " + subMr.getId()));
                }
                mr.addChildModel(PlayerItemParser.getNextModelId(), subMr);
            }
        }
        return mr;
    }

    private static Attachment[] parseAttachments(JsonObject jo2) {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (AttachmentType type : AttachmentType.values()) {
            Attachment at = Attachment.parse((JsonObject)jo2, (AttachmentType)type);
            if (at == null) continue;
            list.add(at);
        }
        if (list.isEmpty()) {
            return null;
        }
        Attachment[] ats = list.toArray(new Attachment[list.size()]);
        return ats;
    }

    public static String getNextModelId() {
        return "MR-" + counter.getAndIncrement();
    }

    private static float[][] parseFaceUvs(JsonObject box) {
        float[][] uvs = new float[][]{Json.parseFloatArray((JsonElement)box.get("uvDown"), (int)4), Json.parseFloatArray((JsonElement)box.get("uvUp"), (int)4), Json.parseFloatArray((JsonElement)box.get("uvNorth"), (int)4), Json.parseFloatArray((JsonElement)box.get("uvSouth"), (int)4), Json.parseFloatArray((JsonElement)box.get("uvWest"), (int)4), Json.parseFloatArray((JsonElement)box.get("uvEast"), (int)4)};
        if (uvs[2] == null) {
            uvs[2] = Json.parseFloatArray((JsonElement)box.get("uvFront"), (int)4);
        }
        if (uvs[3] == null) {
            uvs[3] = Json.parseFloatArray((JsonElement)box.get("uvBack"), (int)4);
        }
        if (uvs[4] == null) {
            uvs[4] = Json.parseFloatArray((JsonElement)box.get("uvLeft"), (int)4);
        }
        if (uvs[5] == null) {
            uvs[5] = Json.parseFloatArray((JsonElement)box.get("uvRight"), (int)4);
        }
        boolean defined = false;
        for (int i = 0; i < uvs.length; ++i) {
            if (uvs[i] == null) continue;
            defined = true;
        }
        if (!defined) {
            return null;
        }
        return uvs;
    }
}

